/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueSerializer;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.reader.FileRecordIterator;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.types.RowType;

public class KeyValueDataFileRecordReader
implements FileRecordReader<KeyValue> {
    private final FileRecordReader<InternalRow> reader;
    private final KeyValueSerializer serializer;
    private final int level;

    public KeyValueDataFileRecordReader(FileRecordReader<InternalRow> reader, RowType keyType, RowType valueType, int level) {
        this.reader = reader;
        this.serializer = new KeyValueSerializer(keyType, valueType);
        this.level = level;
    }

    @Override
    @Nullable
    public FileRecordIterator<KeyValue> readBatch() throws IOException {
        RecordReader.RecordIterator iterator = this.reader.readBatch();
        if (iterator == null) {
            return null;
        }
        return iterator.transform(internalRow -> internalRow == null ? null : this.serializer.fromRow((InternalRow)internalRow).setLevel(this.level));
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

