/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.text;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.paimon.format.HadoopCompressionType;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.SeekableInputStream;

public class HadoopCompressionUtils {
    public static OutputStream createCompressedOutputStream(PositionOutputStream out, String compression) throws IOException {
        Optional<CompressionCodec> codecOpt = HadoopCompressionUtils.getCompressionCodecByCompression(compression);
        if (codecOpt.isPresent()) {
            return codecOpt.get().createOutputStream((OutputStream)out);
        }
        return out;
    }

    public static InputStream createDecompressedInputStream(SeekableInputStream inputStream, org.apache.paimon.fs.Path filePath) throws IOException {
        try {
            if (filePath == null) {
                return inputStream;
            }
            CompressionCodecFactory codecFactory = new CompressionCodecFactory(new Configuration(false));
            CompressionCodec codec = codecFactory.getCodec(new Path(filePath.toString()));
            if (codec != null) {
                return codec.createInputStream((InputStream)inputStream);
            }
            return inputStream;
        }
        catch (Exception | UnsatisfiedLinkError e) {
            throw new RuntimeException("Failed to create decompression stream", e);
        }
    }

    public static Optional<CompressionCodec> getCompressionCodecByCompression(String compression) {
        HadoopCompressionType compressionType = HadoopCompressionType.fromValue(compression).orElseThrow(IllegalArgumentException::new);
        if (HadoopCompressionType.NONE == compressionType) {
            return Optional.empty();
        }
        try {
            String codecName = compressionType.hadoopCodecClassName();
            Class<?> codecClass = Class.forName(codecName);
            CompressionCodec codec = (CompressionCodec)codecClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            codec.createOutputStream((OutputStream)new ByteArrayOutputStream());
            return Optional.of(codec);
        }
        catch (Exception | UnsatisfiedLinkError e) {
            throw new RuntimeException("Failed to get compression codec", e);
        }
    }
}

