/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format;

import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;

public interface FileFormatFactory {
    public String identifier();

    public FileFormat create(FormatContext var1);

    public static class FormatContext {
        private final Options options;
        private final int readBatchSize;
        private final int writeBatchSize;
        private final MemorySize writeBatchMemory;
        private final int zstdLevel;
        @Nullable
        private final MemorySize blockSize;

        @VisibleForTesting
        public FormatContext(Options options, int readBatchSize, int writeBatchSize) {
            this(options, readBatchSize, writeBatchSize, MemorySize.VALUE_128_MB, 1, null);
        }

        @VisibleForTesting
        public FormatContext(Options options, int readBatchSize, int writeBatchSize, MemorySize writeBatchMemory) {
            this(options, readBatchSize, writeBatchSize, writeBatchMemory, 1, null);
        }

        public FormatContext(Options options, int readBatchSize, int writeBatchSize, MemorySize writeBatchMemory, int zstdLevel, @Nullable MemorySize blockSize) {
            this.options = options;
            this.readBatchSize = readBatchSize;
            this.writeBatchSize = writeBatchSize;
            this.writeBatchMemory = writeBatchMemory;
            this.zstdLevel = zstdLevel;
            this.blockSize = blockSize;
        }

        public Options options() {
            return this.options;
        }

        public int readBatchSize() {
            return this.readBatchSize;
        }

        public int writeBatchSize() {
            return this.writeBatchSize;
        }

        public MemorySize writeBatchMemory() {
            return this.writeBatchMemory;
        }

        public int zstdLevel() {
            return this.zstdLevel;
        }

        @Nullable
        public MemorySize blockSize() {
            return this.blockSize;
        }
    }
}

