/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.variant;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathSegment {
    private final String key;
    private final Integer index;
    private static final Pattern ROOT_PATTERN = Pattern.compile("\\$");
    private static final Pattern INDEX_PATTERN = Pattern.compile("\\[(\\d+)]");
    private static final Pattern KEY_PATTERN = Pattern.compile("\\.([^.\\[]+)|\\['([^']+)']|\\[\"([^\"]+)\"]");

    private PathSegment(String key, Integer index) {
        this.key = key;
        this.index = index;
    }

    public static PathSegment createKeySegment(String key) {
        return new PathSegment(key, null);
    }

    public static PathSegment createIndexSegment(int index) {
        return new PathSegment(null, index);
    }

    public boolean isKey() {
        return this.key != null;
    }

    public boolean isIndex() {
        return this.index != null;
    }

    public String getKey() {
        return this.key;
    }

    public Integer getIndex() {
        return this.index;
    }

    public static PathSegment[] parse(String str) {
        Matcher rootMatcher = ROOT_PATTERN.matcher(str);
        if (str.isEmpty() || !rootMatcher.find()) {
            throw new IllegalArgumentException("Invalid path: " + str);
        }
        ArrayList<PathSegment> segments = new ArrayList<PathSegment>();
        String remaining = str.substring(rootMatcher.end());
        while (!remaining.isEmpty()) {
            Matcher indexMatcher = INDEX_PATTERN.matcher(remaining);
            if (indexMatcher.lookingAt()) {
                int index = Integer.parseInt(indexMatcher.group(1));
                segments.add(PathSegment.createIndexSegment(index));
                remaining = remaining.substring(indexMatcher.end());
                continue;
            }
            Matcher keyMatcher = KEY_PATTERN.matcher(remaining);
            if (keyMatcher.lookingAt()) {
                for (int i = 1; i <= 3; ++i) {
                    if (keyMatcher.group(i) == null) continue;
                    segments.add(PathSegment.createKeySegment(keyMatcher.group(i)));
                    break;
                }
                remaining = remaining.substring(keyMatcher.end());
                continue;
            }
            throw new IllegalArgumentException("Invalid path: " + str);
        }
        return segments.toArray(new PathSegment[0]);
    }
}

