/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.bucket;

import java.io.Serializable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.bucket.DefaultBucketFunction;
import org.apache.paimon.bucket.ModBucketFunction;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.types.RowType;

public interface BucketFunction
extends Serializable {
    public int bucket(BinaryRow var1, int var2);

    public static BucketFunction create(CoreOptions options, RowType bucketKeyType) {
        CoreOptions.BucketFunctionType type = options.bucketFunctionType();
        return BucketFunction.create(type, bucketKeyType);
    }

    public static BucketFunction create(CoreOptions.BucketFunctionType bucketFunctionType, RowType bucketKeyType) {
        switch (bucketFunctionType) {
            case DEFAULT: {
                return new DefaultBucketFunction();
            }
            case MOD: {
                return new ModBucketFunction(bucketKeyType);
            }
        }
        throw new IllegalArgumentException("Unsupported bucket type: " + bucketFunctionType);
    }
}

