/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.AbstractFileStore;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.BucketedDvMaintainer;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.operation.AppendFileStoreWrite;
import org.apache.paimon.operation.AppendOnlyFileStoreScan;
import org.apache.paimon.operation.BaseAppendFileStoreWrite;
import org.apache.paimon.operation.BucketSelectConverter;
import org.apache.paimon.operation.BucketedAppendFileStoreWrite;
import org.apache.paimon.operation.DataEvolutionSplitRead;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.types.RowType;

public class AppendOnlyFileStore
extends AbstractFileStore<InternalRow> {
    private final RowType bucketKeyType;
    private final RowType rowType;

    public AppendOnlyFileStore(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, CoreOptions options, RowType partitionType, RowType bucketKeyType, RowType rowType, String tableName, CatalogEnvironment catalogEnvironment) {
        super(fileIO, schemaManager, schema, tableName, options, partitionType, catalogEnvironment);
        this.bucketKeyType = bucketKeyType;
        this.rowType = rowType;
    }

    @Override
    public BucketMode bucketMode() {
        return this.options.bucket() == -1 ? BucketMode.BUCKET_UNAWARE : BucketMode.HASH_FIXED;
    }

    public RawFileSplitRead newRead() {
        return new RawFileSplitRead(this.fileIO, this.schemaManager, this.schema, this.rowType, FileFormatDiscover.of(this.options), this.pathFactory(), this.options.fileIndexReadEnabled(), this.options.rowTrackingEnabled());
    }

    public DataEvolutionSplitRead newDataEvolutionRead() {
        if (!this.options.dataEvolutionEnabled()) {
            throw new IllegalStateException("Field merge read is only supported when data-evolution.enabled is true.");
        }
        return new DataEvolutionSplitRead(this.fileIO, this.schemaManager, this.schema, this.rowType, FileFormatDiscover.of(this.options), this.pathFactory());
    }

    public BaseAppendFileStoreWrite newWrite(String commitUser) {
        return this.newWrite(commitUser, null);
    }

    public BaseAppendFileStoreWrite newWrite(String commitUser, @Nullable Integer writeId) {
        if (this.bucketMode() == BucketMode.BUCKET_UNAWARE) {
            RawFileSplitRead readForCompact = this.newRead();
            if (this.options.rowTrackingEnabled()) {
                readForCompact.withReadType(SpecialFields.rowTypeWithRowTracking(this.rowType));
            }
            return new AppendFileStoreWrite(this.fileIO, readForCompact, this.schema.id(), this.rowType, this.partitionType, this.pathFactory(), this.snapshotManager(), this.newScan(), this.options, this.tableName);
        }
        BucketedDvMaintainer.Factory dvMaintainerFactory = this.options.deletionVectorsEnabled() ? BucketedDvMaintainer.factory(this.newIndexFileHandler()) : null;
        return new BucketedAppendFileStoreWrite(this.fileIO, this.newRead(), this.schema.id(), commitUser, this.rowType, this.partitionType, this.pathFactory(), this.snapshotManager(), this.newScan(), this.options, dvMaintainerFactory, this.tableName);
    }

    @Override
    public AppendOnlyFileStoreScan newScan() {
        BucketSelectConverter bucketSelectConverter = predicate -> {
            if (this.bucketMode() != BucketMode.HASH_FIXED) {
                return Optional.empty();
            }
            if (this.bucketKeyType.getFieldCount() == 0) {
                return Optional.empty();
            }
            List<Predicate> bucketFilters = PredicateBuilder.pickTransformFieldMapping(PredicateBuilder.splitAnd(predicate), this.rowType.getFieldNames(), this.bucketKeyType.getFieldNames());
            if (!bucketFilters.isEmpty()) {
                return BucketSelectConverter.create(PredicateBuilder.and(bucketFilters), this.bucketKeyType, this.options.bucketFunctionType());
            }
            return Optional.empty();
        };
        return new AppendOnlyFileStoreScan(this.newManifestsReader(), bucketSelectConverter, this.snapshotManager(), this.schemaManager, this.schema, this.manifestFileFactory(), this.options.scanManifestParallelism(), this.options.fileIndexReadEnabled());
    }

    @Override
    public Comparator<InternalRow> newKeyComparator() {
        return null;
    }
}

