/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.utils.Preconditions;

@Public
public class MultisetType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT = "MULTISET<%s>";
    private final DataType elementType;

    public MultisetType(boolean isNullable, DataType elementType) {
        super(isNullable, DataTypeRoot.MULTISET);
        this.elementType = Preconditions.checkNotNull(elementType, "Element type must not be null.");
    }

    public MultisetType(DataType elementType) {
        this(true, elementType);
    }

    public DataType getElementType() {
        return this.elementType;
    }

    @Override
    public int defaultSize() {
        return this.elementType.defaultSize() + 4;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new MultisetType(isNullable, this.elementType);
    }

    @Override
    public String asSQLString() {
        return this.withNullability(FORMAT, this.elementType.asSQLString());
    }

    @Override
    public void serializeJson(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", this.isNullable() ? "MULTISET" : "MULTISET NOT NULL");
        generator.writeFieldName("element");
        this.elementType.serializeJson(generator);
        generator.writeEndObject();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultisetType that = (MultisetType)o;
        return this.elementType.equals(that.elementType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementType);
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void collectFieldIds(Set<Integer> fieldIds) {
        this.elementType.collectFieldIds(fieldIds);
    }
}

