/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTApi;
import org.apache.paimon.rest.exceptions.RESTException;
import org.apache.paimon.shade.guava30.com.google.common.base.Joiner;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.shade.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.paimon.shade.hc.core5.http.ParseException;
import org.apache.paimon.shade.hc.core5.http.io.entity.EntityUtils;
import org.apache.paimon.shade.hc.core5.net.URIBuilder;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.utils.Preconditions;

public class RESTUtil {
    private static final Joiner.MapJoiner FORM_JOINER = Joiner.on("&").withKeyValueSeparator("=");

    public static Map<String, String> extractPrefixMap(Options options, String prefix) {
        return RESTUtil.extractPrefixMap(options.toMap(), prefix);
    }

    public static Map<String, String> extractPrefixMap(Map<String, String> properties, String prefix) {
        Preconditions.checkNotNull(properties, "Invalid properties map: null");
        HashMap<String, String> result = Maps.newHashMap();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().startsWith(prefix)) continue;
            result.put(entry.getKey().substring(prefix.length()), properties.get(entry.getKey()));
        }
        return result;
    }

    public static Map<String, String> merge(Map<String, String> baseProperties, Map<String, String> overrideProperties) {
        if (overrideProperties == null) {
            overrideProperties = Maps.newHashMap();
        }
        if (baseProperties == null) {
            baseProperties = Maps.newHashMap();
        }
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : baseProperties.entrySet()) {
            if (entry.getValue() == null || overrideProperties.containsKey(entry.getKey())) continue;
            builder.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : overrideProperties.entrySet()) {
            if (entry.getValue() == null) continue;
            builder.put(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public static String encodeString(String toEncode) {
        Preconditions.checkArgument(toEncode != null, "Invalid string to encode: null");
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(String.format("Failed to URL encode '%s': UTF-8 encoding is not supported", toEncode), e);
        }
    }

    public static String decodeString(String encoded) {
        Preconditions.checkArgument(encoded != null, "Invalid string to decode: null");
        try {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(String.format("Failed to URL decode '%s': UTF-8 encoding is not supported", encoded), e);
        }
    }

    public static void validatePrefixSqlPattern(String pattern) {
        if (pattern != null && !pattern.isEmpty()) {
            boolean escaped = false;
            boolean inWildcardZone = false;
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (escaped) {
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == '%') {
                    inWildcardZone = true;
                    continue;
                }
                if (!inWildcardZone) continue;
                throw new IllegalArgumentException("Can only support prefix sql like pattern query now.");
            }
        }
    }

    public static String encodedBody(Object body) {
        if (body instanceof Map) {
            Map formData = (Map)body;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            formData.forEach((key, value) -> builder.put(RESTUtil.encodeString(String.valueOf(key)), RESTUtil.encodeString(String.valueOf(value))));
            return FORM_JOINER.join(builder.build());
        }
        if (body != null) {
            try {
                return RESTApi.toJson(body);
            }
            catch (JsonProcessingException e) {
                throw new RESTException(e, "Failed to encode request body: %s", body);
            }
        }
        return null;
    }

    public static String extractResponseBodyAsString(CloseableHttpResponse response) throws IOException, ParseException {
        if (response.getEntity() == null) {
            return null;
        }
        return EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
    }

    public static boolean isSuccessful(CloseableHttpResponse response) {
        int code = response.getCode();
        return code == 200 || code == 202 || code == 204;
    }

    public static String buildRequestUrl(String url, Map<String, String> queryParams) {
        try {
            if (queryParams != null && !queryParams.isEmpty()) {
                URIBuilder builder = new URIBuilder(url);
                for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                    builder.addParameter(entry.getKey(), entry.getValue());
                }
                url = builder.build().toString();
            }
        }
        catch (URISyntaxException e) {
            throw new RESTException(e, "build request URL failed.", new Object[0]);
        }
        return url;
    }
}

