/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.fs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.paimon.format.fs.FSDataWrappedInputStream;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;

public class HadoopReadOnlyFileSystem
extends FileSystem {
    private final FileIO fileIO;

    public HadoopReadOnlyFileSystem(FileIO fileIO) {
        this.fileIO = fileIO;
    }

    public URI getUri() {
        throw new UnsupportedOperationException();
    }

    public FSDataInputStream open(Path path) throws IOException {
        return new FSDataInputStream((InputStream)new FSDataWrappedInputStream(this.fileIO.newInputStream(HadoopReadOnlyFileSystem.toPaimonPath(path))));
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        return this.open(path);
    }

    public org.apache.hadoop.fs.FileStatus getFileStatus(Path path) throws IOException {
        return HadoopReadOnlyFileSystem.toHadoopStatus(this.fileIO.getFileStatus(HadoopReadOnlyFileSystem.toPaimonPath(path)));
    }

    private static org.apache.paimon.fs.Path toPaimonPath(Path path) {
        return new org.apache.paimon.fs.Path(path.toUri());
    }

    private static Path toHadoopPath(org.apache.paimon.fs.Path path) {
        return new Path(path.toUri());
    }

    private static org.apache.hadoop.fs.FileStatus toHadoopStatus(FileStatus status) {
        return new org.apache.hadoop.fs.FileStatus(status.getLen(), status.isDir(), 0, 0L, 0L, 0L, null, null, null, HadoopReadOnlyFileSystem.toHadoopPath(status.getPath()));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        throw new UnsupportedOperationException();
    }

    public org.apache.hadoop.fs.FileStatus[] listStatus(Path path) {
        throw new UnsupportedOperationException();
    }

    public void setWorkingDirectory(Path path) {
        throw new UnsupportedOperationException();
    }

    public Path getWorkingDirectory() {
        throw new UnsupportedOperationException();
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) {
        throw new UnsupportedOperationException();
    }
}

