/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.rangebitmap;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.paimon.fileindex.FileIndexReader;
import org.apache.paimon.fileindex.FileIndexResult;
import org.apache.paimon.fileindex.FileIndexWriter;
import org.apache.paimon.fileindex.FileIndexer;
import org.apache.paimon.fileindex.bitmap.BitmapIndexResult;
import org.apache.paimon.fileindex.rangebitmap.RangeBitmap;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.KeyFactory;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.predicate.SortValue;
import org.apache.paimon.predicate.TopN;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.RoaringBitmap32;

public class RangeBitmapFileIndex
implements FileIndexer {
    public static final int VERSION_1 = 1;
    public static final int CURRENT_VERSION = 1;
    private final DataType dataType;
    private final Options options;
    public static final String CHUNK_SIZE = "chunk-size";

    public RangeBitmapFileIndex(DataType dataType, Options options) {
        this.dataType = dataType;
        this.options = options;
    }

    @Override
    public FileIndexWriter createWriter() {
        return new Writer(this.dataType, this.options);
    }

    @Override
    public FileIndexReader createReader(SeekableInputStream in, int start, int length) {
        return new Reader(this.dataType, in, start);
    }

    private static class Reader
    extends FileIndexReader {
        private final Function<Object, Object> converter;
        private final RangeBitmap bitmap;

        public Reader(DataType dataType, SeekableInputStream in, int start) {
            KeyFactory factory = KeyFactory.create(dataType);
            this.converter = factory.createConverter();
            this.bitmap = new RangeBitmap(in, start, factory);
        }

        @Override
        public FileIndexResult visitIsNull(FieldRef fieldRef) {
            return new BitmapIndexResult(this.bitmap::isNull);
        }

        @Override
        public FileIndexResult visitIsNotNull(FieldRef fieldRef) {
            return new BitmapIndexResult(this.bitmap::isNotNull);
        }

        @Override
        public FileIndexResult visitEqual(FieldRef fieldRef, Object literal) {
            return new BitmapIndexResult(() -> this.bitmap.eq(this.converter.apply(literal)));
        }

        @Override
        public FileIndexResult visitNotEqual(FieldRef fieldRef, Object literal) {
            return new BitmapIndexResult(() -> this.bitmap.neq(this.converter.apply(literal)));
        }

        @Override
        public FileIndexResult visitIn(FieldRef fieldRef, List<Object> literals) {
            return new BitmapIndexResult(() -> this.bitmap.in(literals.stream().map(this.converter).collect(Collectors.toList())));
        }

        @Override
        public FileIndexResult visitNotIn(FieldRef fieldRef, List<Object> literals) {
            return new BitmapIndexResult(() -> this.bitmap.notIn(literals.stream().map(this.converter).collect(Collectors.toList())));
        }

        @Override
        public FileIndexResult visitLessThan(FieldRef fieldRef, Object literal) {
            return new BitmapIndexResult(() -> this.bitmap.lt(this.converter.apply(literal)));
        }

        @Override
        public FileIndexResult visitLessOrEqual(FieldRef fieldRef, Object literal) {
            return new BitmapIndexResult(() -> this.bitmap.lte(this.converter.apply(literal)));
        }

        @Override
        public FileIndexResult visitGreaterThan(FieldRef fieldRef, Object literal) {
            return new BitmapIndexResult(() -> this.bitmap.gt(this.converter.apply(literal)));
        }

        @Override
        public FileIndexResult visitGreaterOrEqual(FieldRef fieldRef, Object literal) {
            return new BitmapIndexResult(() -> this.bitmap.gte(this.converter.apply(literal)));
        }

        @Override
        public FileIndexResult visitTopN(TopN topN, FileIndexResult result) {
            boolean strict;
            RoaringBitmap32 foundSet = result instanceof BitmapIndexResult ? (RoaringBitmap32)((BitmapIndexResult)result).get() : null;
            int limit = topN.limit();
            List<SortValue> orders = topN.orders();
            SortValue sort = orders.get(0);
            SortValue.NullOrdering nullOrdering = sort.nullOrdering();
            boolean bl = strict = orders.size() == 1;
            if (SortValue.SortDirection.ASCENDING.equals((Object)sort.direction())) {
                return new BitmapIndexResult(() -> this.bitmap.bottomK(limit, nullOrdering, foundSet, strict));
            }
            return new BitmapIndexResult(() -> this.bitmap.topK(limit, nullOrdering, foundSet, strict));
        }
    }

    private static class Writer
    extends FileIndexWriter {
        private final Function<Object, Object> converter;
        private final RangeBitmap.Appender appender;

        public Writer(DataType dataType, Options options) {
            KeyFactory factory = KeyFactory.create(dataType);
            String chunkSize = options.getString(RangeBitmapFileIndex.CHUNK_SIZE, factory.defaultChunkSize());
            this.converter = factory.createConverter();
            this.appender = new RangeBitmap.Appender(factory, (int)MemorySize.parse(chunkSize).getBytes());
        }

        @Override
        public void write(Object key) {
            this.appender.append(this.converter.apply(key));
        }

        @Override
        public byte[] serializedBytes() {
            return this.appender.serialize();
        }
    }
}

