/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.VarCharType;

public class ArrayToStringCastRule
extends AbstractCastRule<InternalArray, BinaryString> {
    static final ArrayToStringCastRule INSTANCE = new ArrayToStringCastRule();

    private ArrayToStringCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.ARRAY).target(DataTypeFamily.CHARACTER_STRING).build());
    }

    @Override
    public CastExecutor<InternalArray, BinaryString> create(DataType inputType, DataType targetType) {
        ArrayType arrayType = (ArrayType)inputType;
        InternalArray.ElementGetter elementGetter = InternalArray.createElementGetter(arrayType.getElementType());
        CastExecutor<?, ?> castExecutor = CastExecutors.resolve(arrayType.getElementType(), VarCharType.STRING_TYPE);
        return arrayData -> {
            int size = arrayData.size();
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < size; ++i) {
                Object o = elementGetter.getElementOrNull((InternalArray)arrayData, i);
                if (o == null) {
                    sb.append("null");
                } else {
                    sb.append(castExecutor.cast(o));
                }
                if (i == size - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            return BinaryString.fromString(sb.toString());
        };
    }
}

