/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.index.IndexPathFactory;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Pair;

public class IndexFilePathFactories {
    private final Map<Pair<BinaryRow, Integer>, IndexPathFactory> cache = new ConcurrentHashMap<Pair<BinaryRow, Integer>, IndexPathFactory>();
    private final FileStorePathFactory pathFactory;

    public IndexFilePathFactories(FileStorePathFactory pathFactory) {
        this.pathFactory = pathFactory;
    }

    public IndexPathFactory get(BinaryRow partition, int bucket) {
        return this.cache.computeIfAbsent(Pair.of(partition, bucket), k -> this.pathFactory.indexFileFactory((BinaryRow)k.getKey(), (Integer)k.getValue()));
    }
}

