/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.AbstractFileStoreTable;
import org.apache.paimon.table.AppendOnlyFileStoreTable;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.FallbackReadFileStoreTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.PrimaryKeyFileStoreTable;
import org.apache.paimon.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreTableFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreTableFactory.class);

    public static FileStoreTable create(CatalogContext context) {
        FileIO fileIO;
        try {
            fileIO = FileIO.get(CoreOptions.path(context.options()), context);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return FileStoreTableFactory.create(fileIO, context.options());
    }

    public static FileStoreTable create(FileIO fileIO, Path path) {
        Options options = new Options();
        options.set(CoreOptions.PATH, path.toString());
        return FileStoreTableFactory.create(fileIO, options);
    }

    public static FileStoreTable create(FileIO fileIO, Options options) {
        Path tablePath = CoreOptions.path(options);
        String branchName = CoreOptions.branch(options.toMap());
        TableSchema tableSchema = new SchemaManager(fileIO, tablePath, branchName).latest().orElseThrow(() -> new IllegalArgumentException("Schema file not found in location " + tablePath + ". Please create table first."));
        return FileStoreTableFactory.create(fileIO, tablePath, tableSchema, options, CatalogEnvironment.empty());
    }

    public static FileStoreTable create(FileIO fileIO, Path tablePath, TableSchema tableSchema) {
        return FileStoreTableFactory.create(fileIO, tablePath, tableSchema, new Options(), CatalogEnvironment.empty());
    }

    public static FileStoreTable create(FileIO fileIO, Path tablePath, TableSchema tableSchema, CatalogEnvironment catalogEnvironment) {
        return FileStoreTableFactory.create(fileIO, tablePath, tableSchema, new Options(), catalogEnvironment);
    }

    public static FileStoreTable create(FileIO fileIO, Path tablePath, TableSchema tableSchema, Options dynamicOptions, CatalogEnvironment catalogEnvironment) {
        FileStoreTable table = FileStoreTableFactory.createWithoutFallbackBranch(fileIO, tablePath, tableSchema, dynamicOptions, catalogEnvironment);
        Options options = new Options(table.options());
        String fallbackBranch = options.get(CoreOptions.SCAN_FALLBACK_BRANCH);
        if (!StringUtils.isNullOrWhitespaceOnly(fallbackBranch)) {
            Options branchOptions = new Options(dynamicOptions.toMap());
            branchOptions.set(CoreOptions.BRANCH, fallbackBranch);
            Optional<TableSchema> schema = new SchemaManager(fileIO, tablePath, fallbackBranch).latest();
            if (schema.isPresent()) {
                Identifier identifier = catalogEnvironment.identifier();
                CatalogEnvironment fallbackCatalogEnvironment = catalogEnvironment;
                if (identifier != null) {
                    fallbackCatalogEnvironment = catalogEnvironment.copy(new Identifier(identifier.getDatabaseName(), identifier.getObjectName(), fallbackBranch));
                }
                FileStoreTable fallbackTable = FileStoreTableFactory.createWithoutFallbackBranch(fileIO, tablePath, schema.get(), branchOptions, fallbackCatalogEnvironment);
                table = new FallbackReadFileStoreTable(table, fallbackTable);
            } else {
                LOG.error("Fallback branch {} not found for table {}", (Object)fallbackBranch, (Object)tablePath);
            }
        }
        return table;
    }

    public static FileStoreTable createWithoutFallbackBranch(FileIO fileIO, Path tablePath, TableSchema tableSchema, Options dynamicOptions, CatalogEnvironment catalogEnvironment) {
        AbstractFileStoreTable table = tableSchema.primaryKeys().isEmpty() ? new AppendOnlyFileStoreTable(fileIO, tablePath, tableSchema, catalogEnvironment) : new PrimaryKeyFileStoreTable(fileIO, tablePath, tableSchema, catalogEnvironment);
        return table.copy((Map)dynamicOptions.toMap());
    }
}

