/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.IndexCastMapping;
import org.apache.paimon.schema.SchemaEvolutionUtil;
import org.apache.paimon.stats.SimpleStatsEvolution;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;

public class SimpleStatsEvolutions {
    private final Function<Long, List<DataField>> schemaFields;
    private final long tableSchemaId;
    private final List<DataField> tableDataFields;
    private final AtomicReference<List<DataField>> tableFields;
    private final ConcurrentMap<Long, SimpleStatsEvolution> evolutions;

    public SimpleStatsEvolutions(Function<Long, List<DataField>> schemaFields, long tableSchemaId) {
        this.schemaFields = schemaFields;
        this.tableSchemaId = tableSchemaId;
        this.tableDataFields = schemaFields.apply(tableSchemaId);
        this.tableFields = new AtomicReference();
        this.evolutions = new ConcurrentHashMap<Long, SimpleStatsEvolution>();
    }

    public SimpleStatsEvolution getOrCreate(long dataSchemaId) {
        return this.evolutions.computeIfAbsent(dataSchemaId, id -> {
            if (this.tableSchemaId == id) {
                return new SimpleStatsEvolution(new RowType(this.schemaFields.apply((Long)id)), null, null);
            }
            List<DataField> schemaTableFields = this.tableFields.updateAndGet(v -> v == null ? this.tableDataFields : v);
            List<DataField> dataFields = this.schemaFields.apply((Long)id);
            IndexCastMapping indexCastMapping = SchemaEvolutionUtil.createIndexCastMapping(schemaTableFields, this.schemaFields.apply((Long)id));
            int[] indexMapping = indexCastMapping.getIndexMapping();
            return new SimpleStatsEvolution(new RowType(dataFields), indexMapping, indexCastMapping.getCastMapping());
        });
    }

    @Nullable
    public Predicate tryDevolveFilter(long dataSchemaId, @Nullable Predicate filter) {
        if (filter == null || dataSchemaId == this.tableSchemaId) {
            return filter;
        }
        List<Predicate> filters = PredicateBuilder.splitAnd(filter);
        List<Predicate> devolved = SchemaEvolutionUtil.devolveFilters(this.tableDataFields, this.schemaFields.apply(dataSchemaId), filters, false);
        return devolved.isEmpty() ? null : PredicateBuilder.and(devolved);
    }

    @Nullable
    public Predicate filterUnsafeFilter(long dataSchemaId, @Nullable Predicate filter, boolean keepNewFieldFilter) {
        if (filter == null || dataSchemaId == this.tableSchemaId) {
            return filter;
        }
        List<Predicate> filters = PredicateBuilder.splitAnd(filter);
        List<DataField> oldSchema = this.schemaFields.apply(dataSchemaId);
        ArrayList<Predicate> result = new ArrayList<Predicate>();
        for (Predicate predicate : filters) {
            if (SchemaEvolutionUtil.devolveFilters(this.tableDataFields, oldSchema, Collections.singletonList(predicate), keepNewFieldFilter).isEmpty()) continue;
            result.add(predicate);
        }
        return result.isEmpty() ? null : PredicateBuilder.and(result);
    }

    public List<DataField> tableDataFields() {
        return this.tableDataFields;
    }
}

