/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;

public class SimpleStatsConverter {
    private final RowType rowType;
    private final boolean denseStore;
    private final InternalRowSerializer serializer;
    private final Map<List<String>, InternalRowSerializer> serializers;

    public SimpleStatsConverter(RowType type) {
        this(type, false);
    }

    public SimpleStatsConverter(RowType type, boolean denseStore) {
        this.rowType = type.copy(type.getFields().stream().map(f -> f.newType(f.type().copy(true))).collect(Collectors.toList()));
        this.denseStore = denseStore;
        this.serializer = new InternalRowSerializer(this.rowType);
        this.serializers = new HashMap<List<String>, InternalRowSerializer>();
    }

    public Pair<List<String>, SimpleStats> toBinary(SimpleColStats[] stats) {
        return this.denseStore ? this.toBinaryDenseMode(stats) : Pair.of(null, this.toBinaryAllMode(stats));
    }

    private Pair<List<String>, SimpleStats> toBinaryDenseMode(SimpleColStats[] stats) {
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<Object> minValues = new ArrayList<Object>();
        ArrayList<Object> maxValues = new ArrayList<Object>();
        ArrayList<Long> nullCounts = new ArrayList<Long>();
        for (int i = 0; i < stats.length; ++i) {
            SimpleColStats colStats = stats[i];
            if (colStats.isNone()) continue;
            fields.add(this.rowType.getFields().get(i).name());
            minValues.add(colStats.min());
            maxValues.add(colStats.max());
            nullCounts.add(colStats.nullCount());
        }
        InternalRowSerializer serializer = this.serializers.computeIfAbsent(fields, key -> new InternalRowSerializer(this.rowType.project((List<String>)key)));
        SimpleStats simpleStats = new SimpleStats(serializer.toBinaryRow(GenericRow.of(minValues.toArray())).copy(), serializer.toBinaryRow(GenericRow.of(maxValues.toArray())).copy(), BinaryArray.fromLongArray(nullCounts.toArray(new Long[0])));
        return Pair.of(fields.size() == this.rowType.getFieldCount() ? null : fields, simpleStats);
    }

    public SimpleStats toBinaryAllMode(SimpleColStats[] stats) {
        int rowFieldCount = stats.length;
        GenericRow minValues = new GenericRow(rowFieldCount);
        GenericRow maxValues = new GenericRow(rowFieldCount);
        Long[] nullCounts = new Long[rowFieldCount];
        for (int i = 0; i < rowFieldCount; ++i) {
            minValues.setField(i, stats[i].min());
            maxValues.setField(i, stats[i].max());
            nullCounts[i] = stats[i].nullCount();
        }
        return new SimpleStats(this.serializer.toBinaryRow(minValues).copy(), this.serializer.toBinaryRow(maxValues).copy(), BinaryArray.fromLongArray(nullCounts));
    }
}

