/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.Snapshot;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class RollbackToTimestampProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("timestamp", DataTypes.LongType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("previous_snapshot_id", DataTypes.LongType, false, Metadata.empty()), new StructField("current_snapshot_id", DataTypes.LongType, false, Metadata.empty())});

    private RollbackToTimestampProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        Long timestamp = args.getLong(1);
        return this.modifyPaimonTable(tableIdent, table -> {
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            SnapshotManager snapshotManager = fileStoreTable.snapshotManager();
            Snapshot latestSnapshot = snapshotManager.latestSnapshot();
            Preconditions.checkNotNull(latestSnapshot, "Latest snapshot is null, can not rollback.");
            Snapshot snapshot = snapshotManager.earlierOrEqualTimeMills(timestamp);
            Preconditions.checkNotNull(snapshot, String.format("Can not find snapshot earlier than %s", timestamp));
            long snapshotId = snapshot.id();
            fileStoreTable.rollbackTo(snapshotId);
            InternalRow outputRow = this.newInternalRow(latestSnapshot.id(), snapshotId);
            return new InternalRow[]{outputRow};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RollbackToTimestampProcedure>(){

            @Override
            public RollbackToTimestampProcedure doBuild() {
                return new RollbackToTimestampProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "RollbackToTimestampProcedure";
    }
}

