/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.hc.client5.http.impl.async;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.paimon.shade.hc.client5.http.AuthenticationStrategy;
import org.apache.paimon.shade.hc.client5.http.EndpointInfo;
import org.apache.paimon.shade.hc.client5.http.HttpRoute;
import org.apache.paimon.shade.hc.client5.http.RouteTracker;
import org.apache.paimon.shade.hc.client5.http.SchemePortResolver;
import org.apache.paimon.shade.hc.client5.http.async.AsyncExecCallback;
import org.apache.paimon.shade.hc.client5.http.async.AsyncExecChain;
import org.apache.paimon.shade.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.paimon.shade.hc.client5.http.async.AsyncExecRuntime;
import org.apache.paimon.shade.hc.client5.http.auth.AuthExchange;
import org.apache.paimon.shade.hc.client5.http.auth.ChallengeType;
import org.apache.paimon.shade.hc.client5.http.config.RequestConfig;
import org.apache.paimon.shade.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler;
import org.apache.paimon.shade.hc.client5.http.impl.auth.AuthCacheKeeper;
import org.apache.paimon.shade.hc.client5.http.impl.auth.HttpAuthenticator;
import org.apache.paimon.shade.hc.client5.http.impl.routing.BasicRouteDirector;
import org.apache.paimon.shade.hc.client5.http.protocol.HttpClientContext;
import org.apache.paimon.shade.hc.client5.http.routing.HttpRouteDirector;
import org.apache.paimon.shade.hc.core5.annotation.Contract;
import org.apache.paimon.shade.hc.core5.annotation.Internal;
import org.apache.paimon.shade.hc.core5.annotation.ThreadingBehavior;
import org.apache.paimon.shade.hc.core5.concurrent.CancellableDependency;
import org.apache.paimon.shade.hc.core5.concurrent.FutureCallback;
import org.apache.paimon.shade.hc.core5.http.EntityDetails;
import org.apache.paimon.shade.hc.core5.http.Header;
import org.apache.paimon.shade.hc.core5.http.HttpException;
import org.apache.paimon.shade.hc.core5.http.HttpHost;
import org.apache.paimon.shade.hc.core5.http.HttpRequest;
import org.apache.paimon.shade.hc.core5.http.HttpResponse;
import org.apache.paimon.shade.hc.core5.http.HttpVersion;
import org.apache.paimon.shade.hc.core5.http.Method;
import org.apache.paimon.shade.hc.core5.http.message.BasicHttpRequest;
import org.apache.paimon.shade.hc.core5.http.message.StatusLine;
import org.apache.paimon.shade.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.paimon.shade.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.paimon.shade.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.paimon.shade.hc.core5.http.nio.CapacityChannel;
import org.apache.paimon.shade.hc.core5.http.nio.DataStreamChannel;
import org.apache.paimon.shade.hc.core5.http.nio.RequestChannel;
import org.apache.paimon.shade.hc.core5.http.protocol.HttpContext;
import org.apache.paimon.shade.hc.core5.http.protocol.HttpProcessor;
import org.apache.paimon.shade.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class AsyncConnectExec
implements AsyncExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncConnectExec.class);
    private final HttpProcessor proxyHttpProcessor;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthCacheKeeper authCacheKeeper;
    private final HttpRouteDirector routeDirector;

    public AsyncConnectExec(HttpProcessor proxyHttpProcessor, AuthenticationStrategy proxyAuthStrategy, SchemePortResolver schemePortResolver, boolean authCachingDisabled) {
        Args.notNull(proxyHttpProcessor, "Proxy HTTP processor");
        Args.notNull(proxyAuthStrategy, "Proxy authentication strategy");
        this.proxyHttpProcessor = proxyHttpProcessor;
        this.proxyAuthStrategy = proxyAuthStrategy;
        this.authenticator = new HttpAuthenticator();
        this.authCacheKeeper = authCachingDisabled ? null : new AuthCacheKeeper(schemePortResolver);
        this.routeDirector = BasicRouteDirector.INSTANCE;
    }

    @Override
    public void execute(final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        String exchangeId = scope.exchangeId;
        HttpRoute route = scope.route;
        CancellableDependency cancellableDependency = scope.cancellableDependency;
        HttpClientContext clientContext = scope.clientContext;
        AsyncExecRuntime execRuntime = scope.execRuntime;
        final State state = new State(route);
        if (!execRuntime.isEndpointAcquired()) {
            Object userToken = clientContext.getUserToken();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} acquiring connection with route {}", (Object)exchangeId, (Object)route);
            }
            cancellableDependency.setDependency(execRuntime.acquireEndpoint(exchangeId, route, userToken, clientContext, new FutureCallback<AsyncExecRuntime>(){

                @Override
                public void completed(AsyncExecRuntime execRuntime) {
                    if (execRuntime.isEndpointConnected()) {
                        try {
                            chain.proceed(request, entityProducer, scope, asyncExecCallback);
                        }
                        catch (IOException | HttpException ex) {
                            asyncExecCallback.failed(ex);
                        }
                    } else {
                        AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                    }
                }

                @Override
                public void failed(Exception ex) {
                    asyncExecCallback.failed(ex);
                }

                @Override
                public void cancelled() {
                    asyncExecCallback.failed(new InterruptedIOException());
                }
            }));
        } else if (execRuntime.isEndpointConnected()) {
            this.proceedConnected(request, entityProducer, scope, chain, asyncExecCallback);
        } else {
            this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
        }
    }

    private void proceedToNextHop(State state, HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) {
        try {
            this.doProceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
        }
        catch (RuntimeException ex) {
            asyncExecCallback.failed(ex);
        }
    }

    private void doProceedToNextHop(final State state, final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) {
        final RouteTracker tracker = state.tracker;
        final String exchangeId = scope.exchangeId;
        final HttpRoute route = scope.route;
        final AsyncExecRuntime execRuntime = scope.execRuntime;
        CancellableDependency operation = scope.cancellableDependency;
        HttpClientContext clientContext = scope.clientContext;
        HttpRoute fact = tracker.toRoute();
        int step = this.routeDirector.nextStep(route, fact);
        switch (step) {
            case 1: {
                operation.setDependency(execRuntime.connectEndpoint(clientContext, new FutureCallback<AsyncExecRuntime>(){

                    @Override
                    public void completed(AsyncExecRuntime execRuntime) {
                        tracker.connectTarget(route.isSecure());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} connected to target", (Object)exchangeId);
                        }
                        AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                    }

                    @Override
                    public void failed(Exception ex) {
                        asyncExecCallback.failed(ex);
                    }

                    @Override
                    public void cancelled() {
                        asyncExecCallback.failed(new InterruptedIOException());
                    }
                }));
                break;
            }
            case 2: {
                operation.setDependency(execRuntime.connectEndpoint(clientContext, new FutureCallback<AsyncExecRuntime>(){

                    @Override
                    public void completed(AsyncExecRuntime execRuntime) {
                        HttpHost proxy = route.getProxyHost();
                        tracker.connectProxy(proxy, route.isSecure() && !route.isTunnelled());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} connected to proxy", (Object)exchangeId);
                        }
                        AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                    }

                    @Override
                    public void failed(Exception ex) {
                        asyncExecCallback.failed(ex);
                    }

                    @Override
                    public void cancelled() {
                        asyncExecCallback.failed(new InterruptedIOException());
                    }
                }));
                break;
            }
            case 3: {
                HttpHost proxy = route.getProxyHost();
                HttpHost target = route.getTargetHost();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} create tunnel", (Object)exchangeId);
                }
                this.createTunnel(state, proxy, target, scope, new AsyncExecCallback(){

                    @Override
                    public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                        return asyncExecCallback.handleResponse(response, entityDetails);
                    }

                    @Override
                    public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                        asyncExecCallback.handleInformationResponse(response);
                    }

                    @Override
                    public void completed() {
                        if (!execRuntime.isEndpointConnected()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} proxy disconnected", (Object)exchangeId);
                            }
                            state.tracker.reset();
                        }
                        if (state.challenged) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} proxy authentication required", (Object)exchangeId);
                            }
                            AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                        } else if (state.tunnelRefused) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} tunnel refused", (Object)exchangeId);
                            }
                            asyncExecCallback.completed();
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} tunnel to target created", (Object)exchangeId);
                            }
                            tracker.tunnelTarget(false);
                            AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                        }
                    }

                    @Override
                    public void failed(Exception cause) {
                        execRuntime.markConnectionNonReusable();
                        asyncExecCallback.failed(cause);
                    }
                });
                break;
            }
            case 4: {
                asyncExecCallback.failed(new HttpException("Proxy chains are not supported"));
                break;
            }
            case 5: {
                execRuntime.upgradeTls(clientContext, new FutureCallback<AsyncExecRuntime>(){

                    @Override
                    public void completed(AsyncExecRuntime asyncExecRuntime) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} upgraded to TLS", (Object)exchangeId);
                        }
                        tracker.layerProtocol(route.isSecure());
                        AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                    }

                    @Override
                    public void failed(Exception ex) {
                        asyncExecCallback.failed(ex);
                    }

                    @Override
                    public void cancelled() {
                        asyncExecCallback.failed(new InterruptedIOException());
                    }
                });
                break;
            }
            case -1: {
                asyncExecCallback.failed(new HttpException("Unable to establish route: planned = " + route + "; current = " + fact));
                break;
            }
            case 0: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} route fully established", (Object)exchangeId);
                }
                this.proceedConnected(request, entityProducer, scope, chain, asyncExecCallback);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown step indicator " + step + " from RouteDirector.");
            }
        }
    }

    private void createTunnel(final State state, final HttpHost proxy, final HttpHost nextHop, AsyncExecChain.Scope scope, final AsyncExecCallback asyncExecCallback) {
        AuthExchange proxyAuthExchange;
        CancellableDependency operation = scope.cancellableDependency;
        final HttpClientContext clientContext = scope.clientContext;
        AsyncExecRuntime execRuntime = scope.execRuntime;
        String exchangeId = scope.exchangeId;
        AuthExchange authExchange = proxyAuthExchange = proxy != null ? clientContext.getAuthExchange(proxy) : new AuthExchange();
        if (this.authCacheKeeper != null) {
            this.authCacheKeeper.loadPreemptively(proxy, null, proxyAuthExchange, clientContext);
        }
        AsyncClientExchangeHandler internalExchangeHandler = new AsyncClientExchangeHandler(){
            private final AtomicReference<AsyncDataConsumer> entityConsumerRef = new AtomicReference();

            @Override
            public void releaseResources() {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.releaseResources();
                }
            }

            @Override
            public void failed(Exception cause) {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.releaseResources();
                }
                asyncExecCallback.failed(cause);
            }

            @Override
            public void cancel() {
                this.failed(new InterruptedIOException());
            }

            @Override
            public void produceRequest(RequestChannel requestChannel, HttpContext httpContext) throws HttpException, IOException {
                BasicHttpRequest connect = new BasicHttpRequest(Method.CONNECT, nextHop, nextHop.toHostString());
                connect.setVersion(HttpVersion.HTTP_1_1);
                AsyncConnectExec.this.proxyHttpProcessor.process(connect, null, (HttpContext)clientContext);
                AsyncConnectExec.this.authenticator.addAuthResponse(proxy, ChallengeType.PROXY, connect, proxyAuthExchange, clientContext);
                requestChannel.sendRequest(connect, null, clientContext);
            }

            @Override
            public void produce(DataStreamChannel dataStreamChannel) throws IOException {
            }

            @Override
            public int available() {
                return 0;
            }

            @Override
            public void consumeInformation(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            }

            @Override
            public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
                clientContext.setResponse(response);
                AsyncConnectExec.this.proxyHttpProcessor.process(response, entityDetails, (HttpContext)clientContext);
                int status = response.getCode();
                if (status < 200) {
                    throw new HttpException("Unexpected response to CONNECT request: " + new StatusLine(response));
                }
                if (AsyncConnectExec.this.needAuthentication(proxyAuthExchange, proxy, response, clientContext)) {
                    state.challenged = true;
                } else {
                    state.challenged = false;
                    if (status >= 300) {
                        state.tunnelRefused = true;
                        this.entityConsumerRef.set(asyncExecCallback.handleResponse(response, entityDetails));
                    } else if (status == 200) {
                        clientContext.setProtocolVersion(null);
                        asyncExecCallback.completed();
                    } else {
                        throw new HttpException("Unexpected response to CONNECT request: " + new StatusLine(response));
                    }
                }
            }

            @Override
            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.get();
                if (entityConsumer != null) {
                    entityConsumer.updateCapacity(capacityChannel);
                } else {
                    capacityChannel.update(Integer.MAX_VALUE);
                }
            }

            @Override
            public void consume(ByteBuffer src) throws IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.get();
                if (entityConsumer != null) {
                    entityConsumer.consume(src);
                }
            }

            @Override
            public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.streamEnd(trailers);
                }
                asyncExecCallback.completed();
            }
        };
        if (LOG.isDebugEnabled()) {
            operation.setDependency(execRuntime.execute(exchangeId, new LoggingAsyncClientExchangeHandler(LOG, exchangeId, internalExchangeHandler), clientContext));
        } else {
            operation.setDependency(execRuntime.execute(exchangeId, internalExchangeHandler, clientContext));
        }
    }

    private boolean needAuthentication(AuthExchange proxyAuthExchange, HttpHost proxy, HttpResponse response, HttpClientContext context) {
        RequestConfig config = context.getRequestConfigOrDefault();
        if (config.isAuthenticationEnabled()) {
            boolean proxyAuthRequested = this.authenticator.isChallenged(proxy, ChallengeType.PROXY, response, proxyAuthExchange, context);
            if (this.authCacheKeeper != null) {
                if (proxyAuthRequested) {
                    this.authCacheKeeper.updateOnChallenge(proxy, null, proxyAuthExchange, context);
                } else {
                    this.authCacheKeeper.updateOnNoChallenge(proxy, null, proxyAuthExchange, context);
                }
            }
            if (proxyAuthRequested) {
                boolean updated = this.authenticator.updateAuthState(proxy, ChallengeType.PROXY, response, this.proxyAuthStrategy, proxyAuthExchange, context);
                if (this.authCacheKeeper != null) {
                    this.authCacheKeeper.updateOnResponse(proxy, null, proxyAuthExchange, context);
                }
                return updated;
            }
        }
        return false;
    }

    private void proceedConnected(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) {
        AsyncExecRuntime execRuntime = scope.execRuntime;
        HttpClientContext clientContext = scope.clientContext;
        EndpointInfo endpointInfo = execRuntime.getEndpointInfo();
        if (endpointInfo != null) {
            clientContext.setSSLSession(endpointInfo.getSslSession());
        }
        try {
            chain.proceed(request, entityProducer, scope, asyncExecCallback);
        }
        catch (IOException | HttpException ex) {
            asyncExecCallback.failed(ex);
        }
    }

    static class State {
        final RouteTracker tracker;
        volatile boolean challenged;
        volatile HttpResponse response;
        volatile boolean tunnelRefused;

        State(HttpRoute route) {
            this.tracker = new RouteTracker(route);
        }
    }
}

