/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.PartitionInfo;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;

public class PartitionUtils {
    public static Pair<Pair<int[], RowType>, List<DataField>> trimPartitionFields(TableSchema dataSchema, List<DataField> dataFields) {
        if (dataSchema.partitionKeys().isEmpty()) {
            return Pair.of(null, dataFields);
        }
        return PartitionUtils.getPartitionMapping2fieldsWithoutPartition(dataSchema.partitionKeys(), dataFields, dataSchema.projectedLogicalRowType(dataSchema.partitionKeys()));
    }

    public static Pair<int[], RowType> getPartitionMapping(List<String> partitionKeys, List<DataField> dataFields, RowType partitionType) {
        return PartitionUtils.getPartitionMapping2fieldsWithoutPartition(partitionKeys, dataFields, partitionType).getLeft();
    }

    public static Pair<Pair<int[], RowType>, List<DataField>> getPartitionMapping2fieldsWithoutPartition(List<String> partitionKeys, List<DataField> dataFields, RowType partitionType) {
        if (partitionKeys.isEmpty()) {
            return Pair.of(null, dataFields);
        }
        ArrayList<DataField> fieldsWithoutPartition = new ArrayList<DataField>();
        int[] map = new int[dataFields.size() + 1];
        int partitionFieldCount = 0;
        for (int i = 0; i < dataFields.size(); ++i) {
            DataField field = dataFields.get(i);
            if (partitionKeys.contains(field.name())) {
                map[i] = -(partitionKeys.indexOf(field.name()) + 1);
                ++partitionFieldCount;
                continue;
            }
            map[i] = i - partitionFieldCount + 1;
            fieldsWithoutPartition.add(field);
        }
        Pair<int[], RowType> partitionMapping = fieldsWithoutPartition.size() == dataFields.size() ? null : Pair.of(map, partitionType);
        return Pair.of(partitionMapping, fieldsWithoutPartition);
    }

    public static PartitionInfo create(@Nullable Pair<int[], RowType> pair, BinaryRow binaryRow) {
        return pair == null ? null : new PartitionInfo(pair.getLeft(), pair.getRight(), binaryRow);
    }

    public static String buildPartitionName(Map<String, String> partitionSpec) {
        if (partitionSpec.isEmpty()) {
            return "";
        }
        List partitionName = partitionSpec.keySet().stream().map(key -> key + "=" + (String)partitionSpec.get(key)).collect(Collectors.toList());
        return String.join((CharSequence)"/", partitionName);
    }
}

