/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors.append;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsIndexFile;
import org.apache.paimon.deletionvectors.append.BaseAppendDeleteFileMaintainer;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.table.source.DeletionFile;

public class AppendDeleteFileMaintainer
implements BaseAppendDeleteFileMaintainer {
    private final DeletionVectorsIndexFile dvIndexFile;
    private final BinaryRow partition;
    private final Map<String, DeletionFile> dataFileToDeletionFile;
    private final Map<String, IndexManifestEntry> indexNameToEntry;
    private final Map<String, Map<String, DeletionFile>> indexFileToDeletionFiles;
    private final Map<String, String> dataFileToIndexFile;
    private final Set<String> touchedIndexFiles;
    private final Map<String, DeletionVector> deletionVectors;

    AppendDeleteFileMaintainer(DeletionVectorsIndexFile dvIndexFile, BinaryRow partition, List<IndexManifestEntry> manifestEntries, Map<String, DeletionFile> deletionFiles) {
        this.dvIndexFile = dvIndexFile;
        this.partition = partition;
        this.dataFileToDeletionFile = new HashMap<String, DeletionFile>(deletionFiles);
        this.deletionVectors = new HashMap<String, DeletionVector>();
        this.indexNameToEntry = new HashMap<String, IndexManifestEntry>();
        for (IndexManifestEntry entry : manifestEntries) {
            this.indexNameToEntry.put(entry.indexFile().fileName(), entry);
        }
        this.indexFileToDeletionFiles = new HashMap<String, Map<String, DeletionFile>>();
        this.dataFileToIndexFile = new HashMap<String, String>();
        for (String dataFile : deletionFiles.keySet()) {
            DeletionFile deletionFile = deletionFiles.get(dataFile);
            String indexFileName = new Path(deletionFile.path()).getName();
            this.indexFileToDeletionFiles.computeIfAbsent(indexFileName, k -> new HashMap()).put(dataFile, deletionFile);
            this.dataFileToIndexFile.put(dataFile, indexFileName);
        }
        this.touchedIndexFiles = new HashSet<String>();
    }

    @Override
    public BinaryRow getPartition() {
        return this.partition;
    }

    @Override
    public int getBucket() {
        return 0;
    }

    public DeletionFile getDeletionFile(String dataFile) {
        return this.dataFileToDeletionFile.get(dataFile);
    }

    public void putDeletionFile(String dataFile, DeletionFile deletionFile) {
        this.dataFileToDeletionFile.put(dataFile, deletionFile);
    }

    public DeletionVector getDeletionVector(String dataFile) {
        DeletionFile deletionFile = this.getDeletionFile(dataFile);
        if (deletionFile != null) {
            return this.dvIndexFile.readDeletionVector(deletionFile);
        }
        return null;
    }

    public DeletionFile notifyRemovedDeletionVector(String dataFile) {
        if (this.dataFileToIndexFile.containsKey(dataFile)) {
            String indexFileName = this.dataFileToIndexFile.get(dataFile);
            this.touchedIndexFiles.add(indexFileName);
            if (this.indexFileToDeletionFiles.containsKey(indexFileName)) {
                return this.indexFileToDeletionFiles.get(indexFileName).remove(dataFile);
            }
        }
        return null;
    }

    @Override
    public void notifyNewDeletionVector(String dataFile, DeletionVector deletionVector) {
        DeletionFile previous = this.notifyRemovedDeletionVector(dataFile);
        if (previous != null) {
            deletionVector.merge(this.dvIndexFile.readDeletionVector(previous));
        }
        this.deletionVectors.put(dataFile, deletionVector);
    }

    @Override
    public List<IndexManifestEntry> persist() {
        List<IndexManifestEntry> result = this.writeUnchangedDeletionVector();
        this.dvIndexFile.writeWithRolling(this.deletionVectors).stream().map(this::toAddEntry).forEach(result::add);
        return result;
    }

    private IndexManifestEntry toAddEntry(IndexFileMeta file) {
        return new IndexManifestEntry(FileKind.ADD, this.partition, 0, file);
    }

    public String getIndexFilePath(String dataFile) {
        DeletionFile deletionFile = this.getDeletionFile(dataFile);
        return deletionFile == null ? null : deletionFile.path();
    }

    @VisibleForTesting
    List<IndexManifestEntry> writeUnchangedDeletionVector() {
        ArrayList<IndexManifestEntry> newIndexEntries = new ArrayList<IndexManifestEntry>();
        for (String indexFile : this.indexFileToDeletionFiles.keySet()) {
            if (!this.touchedIndexFiles.contains(indexFile)) continue;
            IndexManifestEntry oldEntry = this.indexNameToEntry.get(indexFile);
            Map<String, DeletionFile> dataFileToDeletionFiles = this.indexFileToDeletionFiles.get(indexFile);
            if (!dataFileToDeletionFiles.isEmpty()) {
                List<IndexFileMeta> newIndexFiles = this.dvIndexFile.writeWithRolling(this.dvIndexFile.readDeletionVector(dataFileToDeletionFiles));
                newIndexFiles.forEach(newIndexFile -> newIndexEntries.add(this.toAddEntry((IndexFileMeta)newIndexFile)));
            }
            newIndexEntries.add(oldEntry.toDeleteEntry());
        }
        return newIndexEntries;
    }
}

