/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class PurgeFilesProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata.empty())});

    private PurgeFilesProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        return this.modifyPaimonTable(tableIdent, table -> {
            try {
                ((FileStoreTable)table).purgeFiles();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return new InternalRow[]{this.newInternalRow(UTF8String.fromString((String)"Success"))};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<PurgeFilesProcedure>(){

            @Override
            public PurgeFilesProcedure doBuild() {
                return new PurgeFilesProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "PurgeFilesProcedure";
    }
}

