/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.privilege;

import java.io.Serializable;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.privilege.NoPrivilegeException;
import org.apache.paimon.privilege.PrivilegeType;

public interface PrivilegeChecker
extends Serializable {
    default public void assertCanSelectOrInsert(Identifier identifier) {
        try {
            this.assertCanSelect(identifier);
        }
        catch (NoPrivilegeException e) {
            try {
                this.assertCanInsert(identifier);
            }
            catch (NoPrivilegeException e1) {
                throw new NoPrivilegeException(e1.getUser(), e1.getObjectType(), e1.getIdentifier(), PrivilegeType.SELECT, PrivilegeType.INSERT);
            }
        }
    }

    public void assertCanSelect(Identifier var1);

    public void assertCanInsert(Identifier var1);

    public void assertCanAlterTable(Identifier var1);

    public void assertCanDropTable(Identifier var1);

    public void assertCanCreateTable(String var1);

    public void assertCanDropDatabase(String var1);

    public void assertCanAlterDatabase(String var1);

    public void assertCanCreateDatabase();

    public void assertCanCreateUser();

    public void assertCanDropUser();

    public void assertCanGrant(String var1, PrivilegeType var2);

    public void assertCanRevoke();
}

