/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.compression.CompressOptions;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.lookup.LookupStoreReader;
import org.apache.paimon.lookup.LookupStoreWriter;
import org.apache.paimon.lookup.hash.HashLookupStoreFactory;
import org.apache.paimon.lookup.sort.SortLookupStoreFactory;
import org.apache.paimon.memory.MemorySlice;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.BloomFilter;

public interface LookupStoreFactory {
    public LookupStoreWriter createWriter(File var1, @Nullable BloomFilter.Builder var2) throws IOException;

    public LookupStoreReader createReader(File var1, Context var2) throws IOException;

    public static Function<Long, BloomFilter.Builder> bfGenerator(Options options) {
        Function<Long, BloomFilter.Builder> bfGenerator = rowCount -> null;
        if (options.get(CoreOptions.LOOKUP_CACHE_BLOOM_FILTER_ENABLED).booleanValue()) {
            double bfFpp = options.get(CoreOptions.LOOKUP_CACHE_BLOOM_FILTER_FPP);
            bfGenerator = rowCount -> {
                if (rowCount > 0L) {
                    return BloomFilter.builder(rowCount, bfFpp);
                }
                return null;
            };
        }
        return bfGenerator;
    }

    public static LookupStoreFactory create(CoreOptions options, CacheManager cacheManager, Comparator<MemorySlice> keyComparator) {
        CompressOptions compression = options.lookupCompressOptions();
        switch (options.lookupLocalFileType()) {
            case SORT: {
                return new SortLookupStoreFactory(keyComparator, cacheManager, options.cachePageSize(), compression);
            }
            case HASH: {
                return new HashLookupStoreFactory(cacheManager, options.cachePageSize(), options.toConfiguration().get(CoreOptions.LOOKUP_HASH_LOAD_FACTOR).floatValue(), compression);
            }
        }
        throw new IllegalArgumentException("Unsupported lookup local file type: " + options.lookupLocalFileType());
    }

    public static interface Context {
    }
}

