/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.utils.Preconditions;

public class PojoDataFileMeta
implements DataFileMeta {
    private final String fileName;
    private final long fileSize;
    private final long rowCount;
    private final BinaryRow minKey;
    private final BinaryRow maxKey;
    private final SimpleStats keyStats;
    private final SimpleStats valueStats;
    private final long minSequenceNumber;
    private final long maxSequenceNumber;
    private final long schemaId;
    private final int level;
    private final List<String> extraFiles;
    private final Timestamp creationTime;
    @Nullable
    private final Long deleteRowCount;
    @Nullable
    private final byte[] embeddedIndex;
    @Nullable
    private final FileSource fileSource;
    @Nullable
    private final List<String> valueStatsCols;
    @Nullable
    private final String externalPath;
    @Nullable
    private final Long firstRowId;
    @Nullable
    private final List<String> writeCols;

    public PojoDataFileMeta(String fileName, long fileSize, long rowCount, BinaryRow minKey, BinaryRow maxKey, SimpleStats keyStats, SimpleStats valueStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, int level, List<String> extraFiles, Timestamp creationTime, @Nullable Long deleteRowCount, @Nullable byte[] embeddedIndex, @Nullable FileSource fileSource, @Nullable List<String> valueStatsCols, @Nullable String externalPath, @Nullable Long firstRowId, @Nullable List<String> writeCols) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.rowCount = rowCount;
        this.embeddedIndex = embeddedIndex;
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.keyStats = keyStats;
        this.valueStats = valueStats;
        this.minSequenceNumber = minSequenceNumber;
        this.maxSequenceNumber = maxSequenceNumber;
        this.level = level;
        this.schemaId = schemaId;
        this.extraFiles = Collections.unmodifiableList(extraFiles);
        this.creationTime = creationTime;
        this.deleteRowCount = deleteRowCount;
        this.fileSource = fileSource;
        this.valueStatsCols = valueStatsCols;
        this.externalPath = externalPath;
        this.firstRowId = firstRowId;
        this.writeCols = writeCols;
    }

    @Override
    public String fileName() {
        return this.fileName;
    }

    @Override
    public long fileSize() {
        return this.fileSize;
    }

    @Override
    public long rowCount() {
        return this.rowCount;
    }

    @Override
    public Optional<Long> deleteRowCount() {
        return Optional.ofNullable(this.deleteRowCount);
    }

    @Override
    public byte[] embeddedIndex() {
        return this.embeddedIndex;
    }

    @Override
    public BinaryRow minKey() {
        return this.minKey;
    }

    @Override
    public BinaryRow maxKey() {
        return this.maxKey;
    }

    @Override
    public SimpleStats keyStats() {
        return this.keyStats;
    }

    @Override
    public SimpleStats valueStats() {
        return this.valueStats;
    }

    @Override
    public long minSequenceNumber() {
        return this.minSequenceNumber;
    }

    @Override
    public long maxSequenceNumber() {
        return this.maxSequenceNumber;
    }

    @Override
    public long schemaId() {
        return this.schemaId;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public List<String> extraFiles() {
        return this.extraFiles;
    }

    @Override
    public Timestamp creationTime() {
        return this.creationTime;
    }

    @Override
    public long creationTimeEpochMillis() {
        return this.creationTime.toLocalDateTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    @Override
    public String fileFormat() {
        String[] split = this.fileName.split("\\.");
        if (split.length == 1) {
            throw new RuntimeException("Can't find format from file: " + this.fileName());
        }
        return split[split.length - 1];
    }

    @Override
    public Optional<String> externalPath() {
        return Optional.ofNullable(this.externalPath);
    }

    @Override
    public Optional<String> externalPathDir() {
        return Optional.ofNullable(this.externalPath).map(Path::new).map(p -> p.getParent().toUri().toString());
    }

    @Override
    public Optional<FileSource> fileSource() {
        return Optional.ofNullable(this.fileSource);
    }

    @Override
    @Nullable
    public List<String> valueStatsCols() {
        return this.valueStatsCols;
    }

    @Override
    @Nullable
    public Long firstRowId() {
        return this.firstRowId;
    }

    @Override
    @Nullable
    public List<String> writeCols() {
        return this.writeCols;
    }

    @Override
    public PojoDataFileMeta upgrade(int newLevel) {
        Preconditions.checkArgument(newLevel > this.level);
        return new PojoDataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, newLevel, this.extraFiles, this.creationTime, this.deleteRowCount, this.embeddedIndex, this.fileSource, this.valueStatsCols, this.externalPath, this.firstRowId, this.writeCols);
    }

    @Override
    public PojoDataFileMeta rename(String newFileName) {
        String newExternalPath = this.externalPathDir().map(dir -> dir + "/" + newFileName).orElse(null);
        return new PojoDataFileMeta(newFileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, this.embeddedIndex, this.fileSource, this.valueStatsCols, newExternalPath, this.firstRowId, this.writeCols);
    }

    @Override
    public PojoDataFileMeta copyWithoutStats() {
        return new PojoDataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, SimpleStats.EMPTY_STATS, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, this.embeddedIndex, this.fileSource, Collections.emptyList(), this.externalPath, this.firstRowId, this.writeCols);
    }

    @Override
    public PojoDataFileMeta assignSequenceNumber(long minSequenceNumber, long maxSequenceNumber) {
        return new PojoDataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, minSequenceNumber, maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, this.embeddedIndex, this.fileSource, this.valueStatsCols, this.externalPath, this.firstRowId, this.writeCols);
    }

    @Override
    public PojoDataFileMeta assignFirstRowId(long firstRowId) {
        return new PojoDataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, this.embeddedIndex, this.fileSource, this.valueStatsCols, this.externalPath, firstRowId, this.writeCols);
    }

    @Override
    public PojoDataFileMeta copy(List<String> newExtraFiles) {
        return new PojoDataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, newExtraFiles, this.creationTime, this.deleteRowCount, this.embeddedIndex, this.fileSource, this.valueStatsCols, this.externalPath, this.firstRowId, this.writeCols);
    }

    @Override
    public PojoDataFileMeta newExternalPath(String newExternalPath) {
        return new PojoDataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, this.embeddedIndex, this.fileSource, this.valueStatsCols, newExternalPath, this.firstRowId, this.writeCols);
    }

    @Override
    public PojoDataFileMeta copy(byte[] newEmbeddedIndex) {
        return new PojoDataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, newEmbeddedIndex, this.fileSource, this.valueStatsCols, this.externalPath, this.firstRowId, this.writeCols);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataFileMeta)) {
            return false;
        }
        DataFileMeta that = (DataFileMeta)o;
        return Objects.equals(this.fileName, that.fileName()) && this.fileSize == that.fileSize() && this.rowCount == that.rowCount() && Arrays.equals(this.embeddedIndex, that.embeddedIndex()) && Objects.equals(this.minKey, that.minKey()) && Objects.equals(this.maxKey, that.maxKey()) && Objects.equals(this.keyStats, that.keyStats()) && Objects.equals(this.valueStats, that.valueStats()) && this.minSequenceNumber == that.minSequenceNumber() && this.maxSequenceNumber == that.maxSequenceNumber() && this.schemaId == that.schemaId() && this.level == that.level() && Objects.equals(this.extraFiles, that.extraFiles()) && Objects.equals(this.creationTime, that.creationTime()) && Objects.equals(this.deleteRowCount, that.deleteRowCount().orElse(null)) && Objects.equals((Object)this.fileSource, that.fileSource().orElse(null)) && Objects.equals(this.valueStatsCols, that.valueStatsCols()) && Objects.equals(this.externalPath, that.externalPath().orElse(null)) && Objects.equals(this.firstRowId, that.firstRowId()) && Objects.equals(this.writeCols, that.writeCols());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileName, this.fileSize, this.rowCount, Arrays.hashCode(this.embeddedIndex), this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, this.fileSource, this.valueStatsCols, this.externalPath, this.firstRowId, this.writeCols});
    }

    public String toString() {
        return String.format("{fileName: %s, fileSize: %d, rowCount: %d, embeddedIndex: %s, minKey: %s, maxKey: %s, keyStats: %s, valueStats: %s, minSequenceNumber: %d, maxSequenceNumber: %d, schemaId: %d, level: %d, extraFiles: %s, creationTime: %s, deleteRowCount: %d, fileSource: %s, valueStatsCols: %s, externalPath: %s, firstRowId: %s, writeCols: %s}", new Object[]{this.fileName, this.fileSize, this.rowCount, Arrays.toString(this.embeddedIndex), this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, this.fileSource, this.valueStatsCols, this.externalPath, this.firstRowId, this.writeCols});
    }
}

