/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.heap.HeapArrayVector;
import org.apache.paimon.data.columnar.heap.HeapBooleanVector;
import org.apache.paimon.data.columnar.heap.HeapByteVector;
import org.apache.paimon.data.columnar.heap.HeapBytesVector;
import org.apache.paimon.data.columnar.heap.HeapDoubleVector;
import org.apache.paimon.data.columnar.heap.HeapFloatVector;
import org.apache.paimon.data.columnar.heap.HeapIntVector;
import org.apache.paimon.data.columnar.heap.HeapLongVector;
import org.apache.paimon.data.columnar.heap.HeapMapVector;
import org.apache.paimon.data.columnar.heap.HeapRowVector;
import org.apache.paimon.data.columnar.heap.HeapShortVector;
import org.apache.paimon.data.columnar.heap.HeapTimestampVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.format.parquet.ParquetSchemaConverter;
import org.apache.paimon.format.parquet.type.ParquetField;
import org.apache.paimon.format.parquet.type.ParquetGroupField;
import org.apache.paimon.format.parquet.type.ParquetPrimitiveField;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.shade.org.apache.parquet.io.ColumnIO;
import org.apache.paimon.shade.org.apache.parquet.io.GroupColumnIO;
import org.apache.paimon.shade.org.apache.parquet.io.MessageColumnIO;
import org.apache.paimon.shade.org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.paimon.shade.org.apache.parquet.schema.Type;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VariantType;
import org.apache.paimon.utils.StringUtils;

public class ParquetReaderUtil {
    public static WritableColumnVector createWritableColumnVector(int batchSize, DataType fieldType) {
        switch (fieldType.getTypeRoot()) {
            case BOOLEAN: {
                return new HeapBooleanVector(batchSize);
            }
            case TINYINT: {
                return new HeapByteVector(batchSize);
            }
            case DOUBLE: {
                return new HeapDoubleVector(batchSize);
            }
            case FLOAT: {
                return new HeapFloatVector(batchSize);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return new HeapIntVector(batchSize);
            }
            case BIGINT: {
                return new HeapLongVector(batchSize);
            }
            case SMALLINT: {
                return new HeapShortVector(batchSize);
            }
            case CHAR: 
            case VARCHAR: 
            case VARBINARY: {
                return new HeapBytesVector(batchSize);
            }
            case BINARY: {
                return new HeapBytesVector(batchSize);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int precision = DataTypeChecks.getPrecision(fieldType);
                if (precision > 6) {
                    return new HeapTimestampVector(batchSize);
                }
                return new HeapLongVector(batchSize);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)fieldType;
                if (ParquetSchemaConverter.is32BitDecimal(decimalType.getPrecision())) {
                    return new HeapIntVector(batchSize);
                }
                if (ParquetSchemaConverter.is64BitDecimal(decimalType.getPrecision())) {
                    return new HeapLongVector(batchSize);
                }
                return new HeapBytesVector(batchSize);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)fieldType;
                return new HeapArrayVector(batchSize, ParquetReaderUtil.createWritableColumnVector(batchSize, arrayType.getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)fieldType;
                return new HeapMapVector(batchSize, ParquetReaderUtil.createWritableColumnVector(batchSize, mapType.getKeyType()), ParquetReaderUtil.createWritableColumnVector(batchSize, mapType.getValueType()));
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)fieldType;
                return new HeapMapVector(batchSize, ParquetReaderUtil.createWritableColumnVector(batchSize, multisetType.getElementType()), ParquetReaderUtil.createWritableColumnVector(batchSize, new IntType(false)));
            }
            case ROW: {
                RowType rowType = (RowType)fieldType;
                ColumnVector[] columnVectors = new WritableColumnVector[rowType.getFieldCount()];
                for (int i = 0; i < columnVectors.length; ++i) {
                    columnVectors[i] = ParquetReaderUtil.createWritableColumnVector(batchSize, rowType.getTypeAt(i));
                }
                return new HeapRowVector(batchSize, columnVectors);
            }
            case VARIANT: {
                ColumnVector[] vectors = new WritableColumnVector[]{new HeapBytesVector(batchSize), new HeapBytesVector(batchSize)};
                return new HeapRowVector(batchSize, vectors);
            }
        }
        throw new UnsupportedOperationException(fieldType + " is not supported now.");
    }

    public static List<ParquetField> buildFieldsList(DataField[] readFields, MessageColumnIO columnIO, RowType[] shreddingSchemas) {
        ArrayList<ParquetField> list = new ArrayList<ParquetField>();
        for (int i = 0; i < readFields.length; ++i) {
            list.add(ParquetReaderUtil.constructField(readFields[i], ParquetReaderUtil.lookupColumnByName(columnIO, readFields[i].name()), shreddingSchemas[i]));
        }
        return list;
    }

    private static ParquetField constructField(DataField dataField, ColumnIO columnIO) {
        return ParquetReaderUtil.constructField(dataField, columnIO, null);
    }

    private static ParquetField constructField(DataField dataField, ColumnIO columnIO, @Nullable RowType shreddingSchema) {
        boolean required = columnIO.getType().getRepetition() == Type.Repetition.REQUIRED;
        int repetitionLevel = columnIO.getRepetitionLevel();
        int definitionLevel = columnIO.getDefinitionLevel();
        DataType type = dataField.type();
        String filedName = dataField.name();
        if (type instanceof RowType) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            RowType rowType = (RowType)type;
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            List<String> fieldNames = rowType.getFieldNames();
            List<DataField> childrens = rowType.getFields();
            for (int i = 0; i < childrens.size(); ++i) {
                fieldsBuilder.add(ParquetReaderUtil.constructField(childrens.get(i), ParquetReaderUtil.lookupColumnByName(groupColumnIO, fieldNames.get(i))));
            }
            return new ParquetGroupField(type, repetitionLevel, definitionLevel, required, (List<ParquetField>)((Object)fieldsBuilder.build()), groupColumnIO.getFieldPath());
        }
        if (type instanceof VariantType) {
            if (shreddingSchema != null) {
                ParquetGroupField parquetField = (ParquetGroupField)ParquetReaderUtil.constructField(dataField.newType(shreddingSchema), columnIO);
                return new ParquetGroupField(type, parquetField.getRepetitionLevel(), parquetField.getDefinitionLevel(), parquetField.isRequired(), parquetField.getChildren(), parquetField.path(), parquetField);
            }
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            PrimitiveColumnIO value = (PrimitiveColumnIO)ParquetReaderUtil.lookupColumnByName(groupColumnIO, "value");
            fieldsBuilder.add(new ParquetPrimitiveField((DataType)new BinaryType(), required, value.getColumnDescriptor(), value.getId(), value.getFieldPath()));
            PrimitiveColumnIO metadata = (PrimitiveColumnIO)ParquetReaderUtil.lookupColumnByName(groupColumnIO, "metadata");
            fieldsBuilder.add(new ParquetPrimitiveField((DataType)new BinaryType(), required, metadata.getColumnDescriptor(), metadata.getId(), metadata.getFieldPath()));
            return new ParquetGroupField(type, repetitionLevel, definitionLevel, required, (List<ParquetField>)((Object)fieldsBuilder.build()), groupColumnIO.getFieldPath());
        }
        if (type instanceof MapType) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            GroupColumnIO keyValueColumnIO = ParquetReaderUtil.getMapKeyValueColumn(groupColumnIO);
            MapType mapType = (MapType)type;
            ParquetField keyField = ParquetReaderUtil.constructField(new DataField(0, "", mapType.getKeyType()), keyValueColumnIO.getChild(0));
            ParquetField valueField = ParquetReaderUtil.constructField(new DataField(0, "", mapType.getValueType()), keyValueColumnIO.getChild(1));
            return new ParquetGroupField(type, repetitionLevel, definitionLevel, required, ImmutableList.of(keyField, valueField), groupColumnIO.getFieldPath());
        }
        if (type instanceof MultisetType) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            GroupColumnIO keyValueColumnIO = ParquetReaderUtil.getMapKeyValueColumn(groupColumnIO);
            MultisetType multisetType = (MultisetType)type;
            ParquetField keyField = ParquetReaderUtil.constructField(new DataField(0, "", multisetType.getElementType()), keyValueColumnIO.getChild(0));
            ParquetField valueField = ParquetReaderUtil.constructField(new DataField(0, "", new IntType()), keyValueColumnIO.getChild(1));
            return new ParquetGroupField(type, repetitionLevel, definitionLevel, required, ImmutableList.of(keyField, valueField), groupColumnIO.getFieldPath());
        }
        if (type instanceof ArrayType) {
            ColumnIO elementTypeColumnIO;
            ArrayType arrayType = (ArrayType)type;
            if (columnIO instanceof GroupColumnIO) {
                GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
                if (!StringUtils.isNullOrWhitespaceOnly(filedName)) {
                    while (!Objects.equals(groupColumnIO.getName(), filedName)) {
                        groupColumnIO = (GroupColumnIO)groupColumnIO.getChild(0);
                    }
                    elementTypeColumnIO = groupColumnIO;
                } else {
                    elementTypeColumnIO = arrayType.getElementType() instanceof RowType ? groupColumnIO : groupColumnIO.getChild(0);
                }
            } else if (columnIO instanceof PrimitiveColumnIO) {
                elementTypeColumnIO = columnIO;
            } else {
                throw new RuntimeException(String.format("Unknown ColumnIO, %s", columnIO));
            }
            ParquetField field = ParquetReaderUtil.constructField(new DataField(0, "", arrayType.getElementType()), ParquetReaderUtil.getArrayElementColumn(elementTypeColumnIO));
            if (repetitionLevel == field.getRepetitionLevel()) {
                repetitionLevel = columnIO.getParent().getRepetitionLevel();
            }
            return new ParquetGroupField(type, repetitionLevel, definitionLevel, required, ImmutableList.of(field), columnIO.getFieldPath());
        }
        PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
        return new ParquetPrimitiveField(type, required, primitiveColumnIO.getColumnDescriptor(), primitiveColumnIO.getId(), primitiveColumnIO.getFieldPath());
    }

    public static ColumnIO lookupColumnByName(GroupColumnIO groupColumnIO, String columnName) {
        ColumnIO columnIO = groupColumnIO.getChild(columnName);
        if (columnIO != null) {
            return columnIO;
        }
        for (int i = 0; i < groupColumnIO.getChildrenCount(); ++i) {
            if (!groupColumnIO.getChild(i).getName().equalsIgnoreCase(columnName)) continue;
            return groupColumnIO.getChild(i);
        }
        throw new RuntimeException("Can not find column io for parquet reader.");
    }

    public static GroupColumnIO getMapKeyValueColumn(GroupColumnIO groupColumnIO) {
        while (groupColumnIO.getChildrenCount() == 1) {
            groupColumnIO = (GroupColumnIO)groupColumnIO.getChild(0);
        }
        return groupColumnIO;
    }

    public static ColumnIO getArrayElementColumn(ColumnIO columnIO) {
        while (columnIO instanceof GroupColumnIO && !columnIO.getType().isRepetition(Type.Repetition.REPEATED)) {
            columnIO = ((GroupColumnIO)columnIO).getChild(0);
        }
        if (columnIO instanceof GroupColumnIO && columnIO.getType().getLogicalTypeAnnotation() == null && ((GroupColumnIO)columnIO).getChildrenCount() == 1 && !columnIO.getName().equals("array") && !columnIO.getName().equals(columnIO.getParent().getName() + "_tuple")) {
            return ((GroupColumnIO)columnIO).getChild(0);
        }
        return columnIO;
    }
}

