/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.json;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.json.JsonFileReader;
import org.apache.paimon.format.json.JsonFormatWriter;
import org.apache.paimon.format.json.JsonOptions;
import org.apache.paimon.fs.CloseShieldOutputStream;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.RowType;

public class JsonFileFormat
extends FileFormat {
    public static final String IDENTIFIER = "json";
    private final JsonOptions options;

    public JsonFileFormat(FileFormatFactory.FormatContext context) {
        super(IDENTIFIER);
        this.options = new JsonOptions(context.options());
    }

    @Override
    public FormatReaderFactory createReaderFactory(RowType dataSchemaRowType, RowType projectedRowType, @Nullable List<Predicate> filters) {
        return new JsonReaderFactory(projectedRowType, this.options);
    }

    @Override
    public FormatWriterFactory createWriterFactory(RowType type) {
        return new JsonWriterFactory(type, this.options);
    }

    @Override
    public void validateDataFields(RowType rowType) {
        List<DataType> fieldTypes = rowType.getFieldTypes();
        for (DataType dataType : fieldTypes) {
            this.validateDataType(dataType);
        }
    }

    private void validateDataType(DataType dataType) {
        DataTypeRoot typeRoot = dataType.getTypeRoot();
        switch (typeRoot) {
            case CHAR: 
            case VARCHAR: 
            case BOOLEAN: 
            case BINARY: 
            case VARBINARY: 
            case DECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case ARRAY: 
            case MAP: 
            case ROW: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type for JSON format: " + dataType);
            }
        }
    }

    private static class JsonWriterFactory
    implements FormatWriterFactory {
        private final RowType rowType;
        private final JsonOptions options;

        public JsonWriterFactory(RowType rowType, JsonOptions options) {
            this.rowType = rowType;
            this.options = options;
        }

        @Override
        public FormatWriter create(PositionOutputStream out, String compression) throws IOException {
            return new JsonFormatWriter(new CloseShieldOutputStream(out), this.rowType, this.options, compression);
        }
    }

    private static class JsonReaderFactory
    implements FormatReaderFactory {
        private final RowType projectedRowType;
        private final JsonOptions options;

        public JsonReaderFactory(RowType projectedRowType, JsonOptions options) {
            this.projectedRowType = projectedRowType;
            this.options = options;
        }

        @Override
        public FileRecordReader<InternalRow> createReader(FormatReaderFactory.Context context) throws IOException {
            FileIO fileIO = context.fileIO();
            Path filePath = context.filePath();
            return new JsonFileReader(fileIO, filePath, this.projectedRowType, this.options);
        }
    }
}

