/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.utils.BinaryStringUtils;

class BooleanToStringCastRule
extends AbstractCastRule<Boolean, BinaryString> {
    static final BooleanToStringCastRule INSTANCE = new BooleanToStringCastRule();

    private BooleanToStringCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.BOOLEAN).target(DataTypeFamily.CHARACTER_STRING).build());
    }

    @Override
    public CastExecutor<Boolean, BinaryString> create(DataType inputType, DataType targetType) {
        return value -> BinaryStringUtils.toCharacterString(BinaryString.fromString(value.toString()), targetType);
    }
}

