/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.util;

import java.util.Iterator;
import java.util.StringJoiner;
import shaded.adbmysql.io.debezium.annotation.Immutable;

@Immutable
public final class Joiner {
    private final StringJoiner joiner;

    public static Joiner on(CharSequence delimiter) {
        return new Joiner(new StringJoiner(delimiter));
    }

    public static Joiner on(CharSequence prefix, CharSequence delimiter) {
        return new Joiner(new StringJoiner(delimiter, prefix, ""));
    }

    public static Joiner on(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        return new Joiner(new StringJoiner(delimiter, prefix, suffix));
    }

    private Joiner(StringJoiner joiner) {
        this.joiner = joiner;
    }

    public String join(Object[] values) {
        for (Object value : values) {
            if (value == null) continue;
            this.joiner.add(value.toString());
        }
        return this.joiner.toString();
    }

    public String join(CharSequence firstValue, CharSequence ... additionalValues) {
        if (firstValue != null) {
            this.joiner.add(firstValue);
        }
        for (CharSequence value : additionalValues) {
            if (value == null) continue;
            this.joiner.add(value);
        }
        return this.joiner.toString();
    }

    public String join(Iterable<?> values) {
        for (Object value : values) {
            if (value == null) continue;
            this.joiner.add(value.toString());
        }
        return this.joiner.toString();
    }

    public String join(Iterable<?> values, CharSequence nextValue, CharSequence ... additionalValues) {
        for (Object value : values) {
            if (value == null) continue;
            this.joiner.add(value.toString());
        }
        if (nextValue != null) {
            this.joiner.add(nextValue);
        }
        for (CharSequence value : additionalValues) {
            if (value == null) continue;
            this.joiner.add(value);
        }
        return this.joiner.toString();
    }

    public String join(Iterator<?> values) {
        while (values.hasNext()) {
            Object value = values.next();
            if (value == null) continue;
            this.joiner.add(value.toString());
        }
        return this.joiner.toString();
    }
}

