/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.util;

import java.util.function.BooleanSupplier;

@FunctionalInterface
public interface DelayStrategy {
    default public boolean sleepWhen(BooleanSupplier criteria) {
        return this.sleepWhen(criteria.getAsBoolean());
    }

    public boolean sleepWhen(boolean var1);

    public static DelayStrategy none() {
        return criteria -> false;
    }

    public static DelayStrategy constant(long delayInMilliseconds) {
        return criteria -> {
            if (!criteria) {
                return false;
            }
            try {
                Thread.sleep(delayInMilliseconds);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return true;
        };
    }

    public static DelayStrategy linear(final long delayInMilliseconds) {
        if (delayInMilliseconds <= 0L) {
            throw new IllegalArgumentException("Initial delay must be positive");
        }
        return new DelayStrategy(){
            private long misses = 0L;

            @Override
            public boolean sleepWhen(boolean criteria) {
                if (!criteria) {
                    this.misses = 0L;
                    return false;
                }
                ++this.misses;
                try {
                    Thread.sleep(this.misses * delayInMilliseconds);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
        };
    }

    public static DelayStrategy exponential(long initialDelayInMilliseconds, long maxDelayInMilliseconds) {
        return DelayStrategy.exponential(initialDelayInMilliseconds, maxDelayInMilliseconds, 2.0);
    }

    public static DelayStrategy exponential(final long initialDelayInMilliseconds, final long maxDelayInMilliseconds, final double backOffMultiplier) {
        if (backOffMultiplier <= 1.0) {
            throw new IllegalArgumentException("Backup multiplier must be greater than 1");
        }
        if (initialDelayInMilliseconds <= 0L) {
            throw new IllegalArgumentException("Initial delay must be positive");
        }
        if (initialDelayInMilliseconds >= maxDelayInMilliseconds) {
            throw new IllegalArgumentException("Maximum delay must be greater than initial delay");
        }
        return new DelayStrategy(){
            private long previousDelay = 0L;

            @Override
            public boolean sleepWhen(boolean criteria) {
                if (!criteria) {
                    this.previousDelay = 0L;
                    return false;
                }
                if (this.previousDelay == 0L) {
                    this.previousDelay = initialDelayInMilliseconds;
                } else {
                    long nextDelay = (long)((double)this.previousDelay * backOffMultiplier);
                    this.previousDelay = Math.min(nextDelay, maxDelayInMilliseconds);
                }
                try {
                    Thread.sleep(this.previousDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
        };
    }
}

