/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;

public class Collect {
    public static <K, V> Map<K, V> fixedSizeMap(final int maximumNumberOfEntries) {
        return new LinkedHashMap<K, V>(maximumNumberOfEntries + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;
            final int evictionSize;
            {
                super(arg0, arg1, arg2);
                this.evictionSize = maximumNumberOfEntries - 1;
            }

            @Override
            public boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > this.evictionSize;
            }
        };
    }

    public static <T, V> Set<T> unmodifiableSet(Function<V, T> extractor, V ... values) {
        HashSet<T> newSet = new HashSet<T>();
        for (V value : values) {
            if (value == null) continue;
            newSet.add(extractor.apply(value));
        }
        return Collections.unmodifiableSet(newSet);
    }

    public static <T, V> Set<T> unmodifiableSet(Function<V, T> extractor, Collection<V> values) {
        HashSet<T> newSet = new HashSet<T>();
        for (V value : values) {
            if (value == null) continue;
            newSet.add(extractor.apply(value));
        }
        return Collections.unmodifiableSet(newSet);
    }

    public static <T> Set<T> unmodifiableSet(Set<T> values, T ... additionalValues) {
        HashSet<T> newSet = new HashSet<T>(values);
        for (T value : values) {
            if (value == null) continue;
            newSet.add(value);
        }
        return Collections.unmodifiableSet(newSet);
    }

    public static <T> Set<T> unmodifiableSet(T ... values) {
        return Collect.unmodifiableSet(Collect.arrayListOf(values));
    }

    public static <T> Set<T> unmodifiableSet(Collection<T> values) {
        return Collections.unmodifiableSet(new HashSet<T>(values));
    }

    public static <T> Set<T> unmodifiableSet(Set<T> values) {
        return Collections.unmodifiableSet(values);
    }

    public static <T> Set<T> unmodifiableSet(Iterator<T> values) {
        HashSet<T> set = new HashSet<T>();
        while (values.hasNext()) {
            set.add(values.next());
        }
        return Collections.unmodifiableSet(set);
    }

    public static <T> List<T> arrayListOf(T[] values) {
        ArrayList<T> result = new ArrayList<T>();
        for (T value : values) {
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    public static <T> List<T> arrayListOf(T first, T ... additional) {
        ArrayList<T> result = new ArrayList<T>();
        result.add(first);
        for (T another : additional) {
            result.add(another);
        }
        return result;
    }

    public static <T> List<T> arrayListOf(Iterable<T> values) {
        ArrayList result = new ArrayList();
        values.forEach(value -> result.add(value));
        return result;
    }

    public static <K, V> Map<K, V> mapOf(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    public static <K, V> Map<K, V> hashMapOf(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> hashMapOf(K key1, V value1, K key2, V value2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> hashMapOf(K key1, V value1, K key2, V value2, K key3, V value3) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> hashMapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> Map<K, V> hashMapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        return map;
    }

    public static <K, V> Map<K, V> hashMapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5, K key6, V value6) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        return map;
    }

    public static <K, V> Map<K, V> linkMapOf(K key, V value) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> linkMapOf(K key1, V value1, K key2, V value2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> linkMapOf(K key1, V value1, K key2, V value2, K key3, V value3) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> linkMapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static Properties propertiesOf(String key, String value) {
        Properties props = new Properties();
        props.put(key, value);
        return props;
    }

    public static Properties propertiesOf(String key1, String value1, String key2, String value2) {
        Properties props = new Properties();
        props.put(key1, value1);
        props.put(key2, value2);
        return props;
    }

    public static Properties propertiesOf(String key1, String value1, String key2, String value2, String key3, String value3) {
        Properties props = new Properties();
        props.put(key1, value1);
        props.put(key2, value2);
        props.put(key3, value3);
        return props;
    }

    public static Properties propertiesOf(String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4) {
        Properties props = new Properties();
        props.put(key1, value1);
        props.put(key2, value2);
        props.put(key3, value3);
        props.put(key4, value4);
        return props;
    }

    public static Properties propertiesOf(String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4, String key5, String value5) {
        Properties props = new Properties();
        props.put(key1, value1);
        props.put(key2, value2);
        props.put(key3, value3);
        props.put(key4, value4);
        props.put(key5, value5);
        return props;
    }

    public static Properties propertiesOf(String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4, String key5, String value5, String key6, String value6) {
        Properties props = new Properties();
        props.put(key1, value1);
        props.put(key2, value2);
        props.put(key3, value3);
        props.put(key4, value4);
        props.put(key5, value5);
        props.put(key6, value6);
        return props;
    }

    public static <T> void set(List<T> list, int index, T value, T defaultValue) {
        while (list.size() <= index) {
            list.add(defaultValue);
        }
        list.set(index, value);
    }

    public static <T> Set<T> minus(Set<T> subtrahend, Set<T> minuend) {
        HashSet<T> r = new HashSet<T>(subtrahend);
        r.removeAll(minuend);
        return r;
    }

    private Collect() {
    }
}

