/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.time;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjuster;
import shaded.adbmysql.io.debezium.time.Conversions;

public class Timestamp {
    public static final String SCHEMA_NAME = "shaded.adbmysql.io.debezium.time.Timestamp";

    public static SchemaBuilder builder() {
        return SchemaBuilder.int64().name(SCHEMA_NAME).version(1);
    }

    public static Schema schema() {
        return Timestamp.builder().build();
    }

    public static long toEpochMillis(Object value, TemporalAdjuster adjuster) {
        if (value instanceof Long) {
            return (Long)value;
        }
        LocalDateTime dateTime = Conversions.toLocalDateTime(value);
        if (adjuster != null) {
            dateTime = dateTime.with(adjuster);
        }
        return dateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    private Timestamp() {
    }
}

