/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.time;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import java.time.Duration;
import java.time.LocalTime;
import shaded.adbmysql.io.debezium.time.Conversions;

public class NanoTime {
    public static final String SCHEMA_NAME = "shaded.adbmysql.io.debezium.time.NanoTime";
    private static final Duration ONE_DAY = Duration.ofDays(1L);

    public static SchemaBuilder builder() {
        return SchemaBuilder.int64().name(SCHEMA_NAME).version(1);
    }

    public static Schema schema() {
        return NanoTime.builder().build();
    }

    public static long toNanoOfDay(Object value, boolean acceptLargeValues) {
        if (value instanceof Duration) {
            Duration duration = (Duration)value;
            if (!acceptLargeValues && (duration.isNegative() || duration.compareTo(ONE_DAY) > 0)) {
                throw new IllegalArgumentException("Time values must be between 00:00:00 and 24:00:00 (inclusive): " + duration);
            }
            return ((Duration)value).toNanos();
        }
        LocalTime time = Conversions.toLocalTime(value);
        return time.toNanoOfDay();
    }

    private NanoTime() {
    }
}

