/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.schema;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import shaded.adbmysql.io.debezium.DebeziumException;
import shaded.adbmysql.io.debezium.pipeline.spi.OffsetContext;
import shaded.adbmysql.io.debezium.pipeline.spi.Partition;
import shaded.adbmysql.io.debezium.relational.Table;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.relational.history.TableChanges;
import shaded.adbmysql.io.debezium.util.Clock;

public class SchemaChangeEvent {
    private final String database;
    private final String schema;
    private final String ddl;
    private final Set<Table> tables;
    private final SchemaChangeEventType type;
    private final Map<String, ?> partition;
    private final Map<String, ?> offset;
    private final Struct source;
    private final boolean isFromSnapshot;
    private TableChanges tableChanges = new TableChanges();

    private SchemaChangeEvent(Map<String, ?> partition, Map<String, ?> offset, Struct source, String database, String schema, String ddl, Table table, SchemaChangeEventType type, boolean isFromSnapshot, TableId previousTableId) {
        this(partition, offset, source, database, schema, ddl, table != null ? Collections.singleton(table) : Collections.emptySet(), type, isFromSnapshot, Clock.SYSTEM.currentTimeAsInstant(), previousTableId);
    }

    private SchemaChangeEvent(Map<String, ?> partition, Map<String, ?> offset, Struct source, String database, String schema, String ddl, Set<Table> tables, SchemaChangeEventType type, boolean isFromSnapshot, Instant timestamp, TableId previousTableId) {
        this.partition = Objects.requireNonNull(partition, "partition must not be null");
        this.offset = Objects.requireNonNull(offset, "offset must not be null");
        this.source = Objects.requireNonNull(source, "source must not be null");
        this.database = Objects.requireNonNull(database, "database must not be null");
        this.schema = schema;
        this.ddl = ddl;
        this.tables = Objects.requireNonNull(tables, "tables must not be null");
        this.type = Objects.requireNonNull(type, "type must not be null");
        this.isFromSnapshot = isFromSnapshot;
        switch (type) {
            case CREATE: {
                tables.forEach(this.tableChanges::create);
                break;
            }
            case ALTER: {
                if (previousTableId == null) {
                    tables.forEach(this.tableChanges::alter);
                    break;
                }
                tables.forEach(t -> this.tableChanges.rename((Table)t, previousTableId));
                break;
            }
            case DROP: {
                tables.forEach(this.tableChanges::drop);
                break;
            }
        }
    }

    public Map<String, ?> getPartition() {
        return this.partition;
    }

    public Map<String, ?> getOffset() {
        return this.offset;
    }

    public Struct getSource() {
        return this.source;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDdl() {
        return this.ddl;
    }

    public Set<Table> getTables() {
        return this.tables;
    }

    public SchemaChangeEventType getType() {
        return this.type;
    }

    public boolean isFromSnapshot() {
        return this.isFromSnapshot;
    }

    public TableChanges getTableChanges() {
        return this.tableChanges;
    }

    public String toString() {
        return "SchemaChangeEvent [database=" + this.database + ", schema=" + this.schema + ", ddl=" + this.ddl + ", tables=" + this.tables + ", type=" + (Object)((Object)this.type) + "]";
    }

    public static SchemaChangeEvent of(SchemaChangeEventType type, Partition partition, OffsetContext offsetContext, String databaseName, String schemaName, String ddl, Table table, boolean isFromSnapshot) {
        return new SchemaChangeEvent(partition.getSourcePartition(), offsetContext.getOffset(), offsetContext.getSourceInfo(), databaseName, schemaName, ddl, table, type, isFromSnapshot, null);
    }

    public static SchemaChangeEvent ofTableChange(TableChanges.TableChange change, Map<String, ?> partition, Map<String, ?> offset, Struct source, String databaseName, String schemaName) {
        return new SchemaChangeEvent(partition, offset, source, databaseName, schemaName, null, change.getTable(), SchemaChangeEvent.toSchemaChangeEventType(change.getType()), false, change.getPreviousId());
    }

    public static SchemaChangeEvent ofDatabase(Partition partition, OffsetContext offsetContext, String databaseName, String ddl, boolean isFromSnapshot) {
        return SchemaChangeEvent.of(SchemaChangeEventType.DATABASE, partition, offsetContext, databaseName, null, ddl, null, isFromSnapshot);
    }

    public static SchemaChangeEvent ofSnapshotCreate(Partition partition, OffsetContext offsetContext, String databaseName, Table table) {
        return SchemaChangeEvent.ofCreate(partition, offsetContext, databaseName, table.id().schema(), null, table, true);
    }

    public static SchemaChangeEvent ofCreate(Partition partition, OffsetContext offsetContext, String databaseName, String schemaName, String ddl, Table table, boolean isFromSnapshot) {
        return SchemaChangeEvent.of(SchemaChangeEventType.CREATE, partition, offsetContext, databaseName, schemaName, ddl, table, isFromSnapshot);
    }

    public static SchemaChangeEvent ofAlter(Partition partition, OffsetContext offsetContext, String databaseName, String schemaName, String ddl, Table table) {
        return SchemaChangeEvent.of(SchemaChangeEventType.ALTER, partition, offsetContext, databaseName, schemaName, ddl, table, false);
    }

    public static SchemaChangeEvent ofRename(Partition partition, OffsetContext offsetContext, String databaseName, String schemaName, String ddl, Table table, TableId previousTableId) {
        return new SchemaChangeEvent(partition.getSourcePartition(), offsetContext.getOffset(), offsetContext.getSourceInfo(), databaseName, schemaName, ddl, table, SchemaChangeEventType.ALTER, false, previousTableId);
    }

    public static SchemaChangeEvent ofDrop(Partition partition, OffsetContext offsetContext, String databaseName, String schemaName, String ddl, Table table) {
        return SchemaChangeEvent.of(SchemaChangeEventType.DROP, partition, offsetContext, databaseName, schemaName, ddl, table, false);
    }

    private static SchemaChangeEventType toSchemaChangeEventType(TableChanges.TableChangeType type) {
        switch (type) {
            case CREATE: {
                return SchemaChangeEventType.CREATE;
            }
            case ALTER: {
                return SchemaChangeEventType.ALTER;
            }
            case DROP: {
                return SchemaChangeEventType.DROP;
            }
        }
        throw new DebeziumException("Unknown table change event type " + (Object)((Object)type));
    }

    public static enum SchemaChangeEventType {
        CREATE,
        ALTER,
        DROP,
        DATABASE;

    }
}

