/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.relational.mapping;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import shaded.adbmysql.io.debezium.annotation.Immutable;
import shaded.adbmysql.io.debezium.relational.Column;
import shaded.adbmysql.io.debezium.relational.ValueConverter;
import shaded.adbmysql.io.debezium.relational.mapping.ColumnMapper;

public class TruncateStrings
implements ColumnMapper {
    private final TruncatingValueConverter converter;

    public TruncateStrings(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("Maximum length must be positive");
        }
        this.converter = new TruncatingValueConverter(maxLength);
    }

    @Override
    public ValueConverter create(Column column) {
        return this.isTruncationPossible(column) ? this.converter : ValueConverter.passthrough();
    }

    @Override
    public void alterFieldSchema(Column column, SchemaBuilder schemaBuilder) {
        if (this.isTruncationPossible(column)) {
            schemaBuilder.parameter("truncateLength", Integer.toString(this.converter.maxLength));
        }
    }

    protected boolean isTruncationPossible(Column column) {
        return column.length() < 0 || column.length() > this.converter.maxLength;
    }

    @Immutable
    protected static final class TruncatingValueConverter
    implements ValueConverter {
        protected final int maxLength;

        public TruncatingValueConverter(int maxLength) {
            this.maxLength = maxLength;
            assert (this.maxLength > 0);
        }

        @Override
        public Object convert(Object value) {
            String str;
            if (value instanceof String && (str = (String)value).length() > this.maxLength) {
                return str.substring(0, this.maxLength);
            }
            return value;
        }
    }
}

