/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.relational.mapping;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import java.util.Locale;
import shaded.adbmysql.io.debezium.relational.Column;
import shaded.adbmysql.io.debezium.relational.ValueConverter;
import shaded.adbmysql.io.debezium.relational.mapping.ColumnMapper;
import shaded.adbmysql.io.debezium.util.Strings;

public class PropagateSourceTypeToSchemaParameter
implements ColumnMapper {
    private static final String TYPE_NAME_PARAMETER_KEY = "__debezium.source.column.type";
    private static final String TYPE_LENGTH_PARAMETER_KEY = "__debezium.source.column.length";
    private static final String TYPE_SCALE_PARAMETER_KEY = "__debezium.source.column.scale";
    private static final String COLUMN_COMMENT_PARAMETER_KEY = "__debezium.source.column.comment";

    @Override
    public ValueConverter create(Column column) {
        return null;
    }

    @Override
    public void alterFieldSchema(Column column, SchemaBuilder schemaBuilder) {
        schemaBuilder.parameter(TYPE_NAME_PARAMETER_KEY, column.typeName().toUpperCase(Locale.ENGLISH));
        if (column.length() != -1) {
            schemaBuilder.parameter(TYPE_LENGTH_PARAMETER_KEY, String.valueOf(column.length()));
        }
        if (column.scale().isPresent()) {
            schemaBuilder.parameter(TYPE_SCALE_PARAMETER_KEY, String.valueOf(column.scale().get()));
        }
        if (!Strings.isNullOrEmpty(column.comment())) {
            schemaBuilder.parameter(COLUMN_COMMENT_PARAMETER_KEY, column.comment());
        }
    }
}

