/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.relational;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.adbmysql.io.debezium.annotation.Immutable;
import shaded.adbmysql.io.debezium.data.Envelope;
import shaded.adbmysql.io.debezium.data.SchemaUtil;
import shaded.adbmysql.io.debezium.relational.StructGenerator;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.schema.DataCollectionSchema;

@Immutable
public class TableSchema
implements DataCollectionSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSchema.class);
    private final TableId id;
    private final Schema keySchema;
    private final Envelope envelopeSchema;
    private final Schema valueSchema;
    private final StructGenerator keyGenerator;
    private final StructGenerator valueGenerator;

    public TableSchema(TableId id, Schema keySchema, StructGenerator keyGenerator, Envelope envelopeSchema, Schema valueSchema, StructGenerator valueGenerator) {
        this.id = id;
        this.keySchema = keySchema;
        this.envelopeSchema = envelopeSchema;
        this.valueSchema = valueSchema;
        this.keyGenerator = keyGenerator != null ? keyGenerator : row -> null;
        this.valueGenerator = valueGenerator != null ? valueGenerator : row -> null;
    }

    @Override
    public TableId id() {
        return this.id;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    @Override
    public Schema keySchema() {
        return this.keySchema;
    }

    @Override
    public Envelope getEnvelopeSchema() {
        return this.envelopeSchema;
    }

    public Struct keyFromColumnData(Object[] columnData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("columnData from current stack: {}", (Object)Arrays.toString(columnData));
        }
        return columnData == null ? null : this.keyGenerator.generateValue(columnData);
    }

    public Struct valueFromColumnData(Object[] columnData) {
        return columnData == null ? null : this.valueGenerator.generateValue(columnData);
    }

    public int hashCode() {
        return this.valueSchema().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TableSchema) {
            TableSchema that = (TableSchema)obj;
            return Objects.equals(this.keySchema(), that.keySchema()) && Objects.equals(this.valueSchema(), that.valueSchema());
        }
        return false;
    }

    public String toString() {
        return "{ key : " + SchemaUtil.asString(this.keySchema()) + ", value : " + SchemaUtil.asString(this.valueSchema()) + " }";
    }
}

