/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.relational;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class SystemVariables {
    private final Map<Scope, ConcurrentMap<String, String>> systemVariables = new ConcurrentHashMap<Scope, ConcurrentMap<String, String>>();

    public SystemVariables() {
        this.systemVariables.put(DefaultScope.DEFAULT_SCOPE, new ConcurrentHashMap());
    }

    public SystemVariables(Scope[] scopes) {
        for (Scope scope : scopes) {
            this.systemVariables.put(scope, new ConcurrentHashMap());
        }
    }

    public SystemVariables(List<Scope> scopes) {
        for (Scope scope : scopes) {
            this.systemVariables.put(scope, new ConcurrentHashMap());
        }
    }

    public SystemVariables setVariable(Scope scope, String name, String value) {
        name = this.variableName(name);
        if (value != null) {
            this.forScope(scope).put(name, value);
        } else {
            this.forScope(scope).remove(name);
        }
        return this;
    }

    public String getVariable(String name, Scope scope) {
        name = this.variableName(name);
        return (String)this.forScope(scope).get(name);
    }

    public String getVariable(String name) {
        List<ConcurrentMap<String, String>> orderedSystemVariablesByPriority = this.getOrderedSystemVariablesByScopePriority();
        name = this.variableName(name);
        for (ConcurrentMap<String, String> variablesByScope : orderedSystemVariablesByPriority) {
            String variableName = (String)variablesByScope.get(name);
            if (variableName == null) continue;
            return variableName;
        }
        return null;
    }

    private List<ConcurrentMap<String, String>> getOrderedSystemVariablesByScopePriority() {
        return this.systemVariables.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((Scope)entry.getKey()).priority())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private String variableName(String name) {
        return name.toLowerCase();
    }

    protected ConcurrentMap<String, String> forScope(Scope scope) {
        if (scope != null) {
            return this.systemVariables.computeIfAbsent(scope, entities -> new ConcurrentHashMap());
        }
        List<ConcurrentMap<String, String>> orderedSystemVariablesByScopePriority = this.getOrderedSystemVariablesByScopePriority();
        return orderedSystemVariablesByScopePriority.isEmpty() ? null : orderedSystemVariablesByScopePriority.get(0);
    }

    public static enum DefaultScope implements Scope
    {
        DEFAULT_SCOPE(100);

        private int priority;

        private DefaultScope(int priority) {
            this.priority = priority;
        }

        @Override
        public int priority() {
            return this.priority;
        }
    }

    public static interface Scope {
        public int priority();
    }
}

