/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.relational;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceConnector;
import shaded.adbmysql.io.debezium.config.ConfigDefinition;
import shaded.adbmysql.io.debezium.config.Configuration;
import shaded.adbmysql.io.debezium.config.Field;
import shaded.adbmysql.io.debezium.relational.ColumnFilterMode;
import shaded.adbmysql.io.debezium.relational.RelationalDatabaseConnectorConfig;
import shaded.adbmysql.io.debezium.relational.Selectors;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.relational.Tables;
import shaded.adbmysql.io.debezium.relational.history.DatabaseHistory;
import shaded.adbmysql.io.debezium.relational.history.DatabaseHistoryListener;
import shaded.adbmysql.io.debezium.relational.history.DatabaseHistoryMetrics;
import shaded.adbmysql.io.debezium.relational.history.HistoryRecordComparator;
import shaded.adbmysql.io.debezium.relational.history.KafkaDatabaseHistory;

public abstract class HistorizedRelationalDatabaseConnectorConfig
extends RelationalDatabaseConnectorConfig {
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 2000;
    private boolean useCatalogBeforeSchema;
    private final String logicalName;
    private final Class<? extends SourceConnector> connectorClass;
    private final boolean multiPartitionMode;
    public static final Field DATABASE_HISTORY = Field.create("database.history").withDisplayName("Database history class").withType(ConfigDef.Type.CLASS).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withInvisibleRecommender().withDescription("The name of the DatabaseHistory class that should be used to store and recover database schema changes. The configuration properties for the history are prefixed with the 'database.history.' string.").withDefault(KafkaDatabaseHistory.class.getName());
    public static final Field JMX_METRICS_ENABLED = Field.create("database.history.metrics.enabled").withDisplayName("Skip DDL statements that cannot be parsed").withType(ConfigDef.Type.BOOLEAN).withImportance(ConfigDef.Importance.LOW).withDescription("Whether to enable JMX history metrics").withDefault(false);
    protected static final ConfigDefinition CONFIG_DEFINITION = RelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().history(DATABASE_HISTORY, DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, KafkaDatabaseHistory.BOOTSTRAP_SERVERS, KafkaDatabaseHistory.TOPIC, KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS, KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS, KafkaDatabaseHistory.KAFKA_QUERY_TIMEOUT_MS).create();

    protected HistorizedRelationalDatabaseConnectorConfig(Class<? extends SourceConnector> connectorClass, Configuration config, String logicalName, Tables.TableFilter systemTablesFilter, boolean useCatalogBeforeSchema, int defaultSnapshotFetchSize, ColumnFilterMode columnFilterMode, boolean multiPartitionMode) {
        super(config, logicalName, systemTablesFilter, TableId::toString, defaultSnapshotFetchSize, columnFilterMode);
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        this.logicalName = logicalName;
        this.connectorClass = connectorClass;
        this.multiPartitionMode = multiPartitionMode;
    }

    protected HistorizedRelationalDatabaseConnectorConfig(Class<? extends SourceConnector> connectorClass, Configuration config, String logicalName, Tables.TableFilter systemTablesFilter, Selectors.TableIdToStringMapper tableIdMapper, boolean useCatalogBeforeSchema, ColumnFilterMode columnFilterMode, boolean multiPartitionMode) {
        super(config, logicalName, systemTablesFilter, tableIdMapper, 2000, columnFilterMode);
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        this.logicalName = logicalName;
        this.connectorClass = connectorClass;
        this.multiPartitionMode = multiPartitionMode;
    }

    public DatabaseHistory getDatabaseHistory() {
        Configuration config = this.getConfig();
        DatabaseHistory databaseHistory = config.getInstance(DATABASE_HISTORY, DatabaseHistory.class);
        if (databaseHistory == null) {
            throw new ConnectException("Unable to instantiate the database history class " + config.getString(DATABASE_HISTORY));
        }
        Configuration dbHistoryConfig = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)config.subset("database.history.", false).edit().withDefault(DatabaseHistory.NAME, this.getLogicalName() + "-dbhistory")).withDefault(KafkaDatabaseHistory.INTERNAL_CONNECTOR_CLASS, this.connectorClass.getName())).withDefault(KafkaDatabaseHistory.INTERNAL_CONNECTOR_ID, this.logicalName)).build();
        DatabaseHistoryListener listener = config.getBoolean(JMX_METRICS_ENABLED) ? new DatabaseHistoryMetrics(this, this.multiPartitionMode) : DatabaseHistoryListener.NOOP;
        HistoryRecordComparator historyComparator = this.getHistoryRecordComparator();
        databaseHistory.configure(dbHistoryConfig, historyComparator, listener, this.useCatalogBeforeSchema);
        return databaseHistory;
    }

    public boolean useCatalogBeforeSchema() {
        return this.useCatalogBeforeSchema;
    }

    protected abstract HistoryRecordComparator getHistoryRecordComparator();
}

