/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.pipeline.spi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shaded.adbmysql.io.debezium.DebeziumException;
import shaded.adbmysql.io.debezium.pipeline.spi.OffsetContext;
import shaded.adbmysql.io.debezium.pipeline.spi.Partition;

public final class Offsets<P extends Partition, O extends OffsetContext>
implements Iterable<Map.Entry<P, O>> {
    private final Map<P, O> offsets;

    private Offsets(Map<P, O> offsets) {
        this.offsets = offsets;
    }

    public static <P extends Partition, O extends OffsetContext> Offsets<P, O> of(P partition, O position) {
        HashMap<P, O> offsets = new HashMap<P, O>();
        offsets.put(partition, position);
        return new Offsets(offsets);
    }

    public static <P extends Partition, O extends OffsetContext> Offsets<P, O> of(Map<P, O> offsets) {
        return new Offsets<P, O>(offsets);
    }

    public void resetOffset(P partition) {
        this.offsets.put(partition, null);
    }

    public Set<P> getPartitions() {
        return this.offsets.keySet();
    }

    public Map<P, O> getOffsets() {
        return this.offsets;
    }

    @Override
    public Iterator<Map.Entry<P, O>> iterator() {
        return this.offsets.entrySet().iterator();
    }

    public P getTheOnlyPartition() {
        if (this.offsets.size() != 1) {
            throw new DebeziumException("The task must be configured to use exactly one partition, " + this.offsets.size() + " found");
        }
        return (P)((Partition)this.offsets.entrySet().iterator().next().getKey());
    }

    public O getTheOnlyOffset() {
        if (this.offsets.size() != 1) {
            throw new DebeziumException("The task must be configured to use exactly one partition, " + this.offsets.size() + " found");
        }
        return (O)((OffsetContext)this.offsets.entrySet().iterator().next().getValue());
    }
}

