/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.pipeline.meters;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import shaded.adbmysql.io.debezium.annotation.ThreadSafe;
import shaded.adbmysql.io.debezium.pipeline.metrics.traits.SnapshotMetricsMXBean;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.schema.DataCollectionId;
import shaded.adbmysql.io.debezium.util.Clock;

@ThreadSafe
public class SnapshotMeter
implements SnapshotMetricsMXBean {
    private final AtomicBoolean snapshotRunning = new AtomicBoolean();
    private final AtomicBoolean snapshotCompleted = new AtomicBoolean();
    private final AtomicBoolean snapshotAborted = new AtomicBoolean();
    private final AtomicLong startTime = new AtomicLong();
    private final AtomicLong stopTime = new AtomicLong();
    private final ConcurrentMap<String, Long> rowsScanned = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<String, String> remainingTables = new ConcurrentHashMap<String, String>();
    private final AtomicReference<String> chunkId = new AtomicReference();
    private final AtomicReference<Object[]> chunkFrom = new AtomicReference();
    private final AtomicReference<Object[]> chunkTo = new AtomicReference();
    private final AtomicReference<Object[]> tableFrom = new AtomicReference();
    private final AtomicReference<Object[]> tableTo = new AtomicReference();
    private final Set<String> capturedTables = Collections.synchronizedSet(new HashSet());
    private final Clock clock;

    public SnapshotMeter(Clock clock) {
        this.clock = clock;
    }

    @Override
    public int getTotalTableCount() {
        return this.capturedTables.size();
    }

    @Override
    public int getRemainingTableCount() {
        return this.remainingTables.size();
    }

    @Override
    public boolean getSnapshotRunning() {
        return this.snapshotRunning.get();
    }

    @Override
    public boolean getSnapshotCompleted() {
        return this.snapshotCompleted.get();
    }

    @Override
    public boolean getSnapshotAborted() {
        return this.snapshotAborted.get();
    }

    @Override
    public long getSnapshotDurationInSeconds() {
        long startMillis = this.startTime.get();
        if (startMillis <= 0L) {
            return 0L;
        }
        long stopMillis = this.stopTime.get();
        if (stopMillis == 0L) {
            stopMillis = this.clock.currentTimeInMillis();
        }
        return (stopMillis - startMillis) / 1000L;
    }

    @Override
    public String[] getCapturedTables() {
        return this.capturedTables.toArray(new String[0]);
    }

    public void monitoredDataCollectionsDetermined(Iterable<? extends DataCollectionId> dataCollectionIds) {
        for (DataCollectionId dataCollectionId : dataCollectionIds) {
            this.remainingTables.put(dataCollectionId.identifier(), "");
            this.capturedTables.add(dataCollectionId.identifier());
        }
    }

    public void dataCollectionSnapshotCompleted(DataCollectionId dataCollectionId, long numRows) {
        this.rowsScanned.put(dataCollectionId.identifier(), numRows);
        this.remainingTables.remove(dataCollectionId.identifier());
    }

    public void snapshotStarted() {
        this.snapshotRunning.set(true);
        this.snapshotCompleted.set(false);
        this.snapshotAborted.set(false);
        this.startTime.set(this.clock.currentTimeInMillis());
        this.stopTime.set(0L);
    }

    public void snapshotCompleted() {
        this.snapshotCompleted.set(true);
        this.snapshotAborted.set(false);
        this.snapshotRunning.set(false);
        this.stopTime.set(this.clock.currentTimeInMillis());
    }

    public void snapshotAborted() {
        this.snapshotCompleted.set(false);
        this.snapshotAborted.set(true);
        this.snapshotRunning.set(false);
        this.stopTime.set(this.clock.currentTimeInMillis());
    }

    public void rowsScanned(TableId tableId, long numRows) {
        this.rowsScanned.put(tableId.toString(), numRows);
    }

    public ConcurrentMap<String, Long> getRowsScanned() {
        return this.rowsScanned;
    }

    public void currentChunk(String chunkId, Object[] chunkFrom, Object[] chunkTo) {
        this.chunkId.set(chunkId);
        this.chunkFrom.set(chunkFrom);
        this.chunkTo.set(chunkTo);
    }

    public void currentChunk(String chunkId, Object[] chunkFrom, Object[] chunkTo, Object[] tableTo) {
        this.currentChunk(chunkId, chunkFrom, chunkTo);
        this.tableFrom.set(chunkFrom);
        this.tableTo.set(tableTo);
    }

    @Override
    public String getChunkId() {
        return this.chunkId.get();
    }

    @Override
    public String getChunkFrom() {
        return this.arrayToString(this.chunkFrom.get());
    }

    @Override
    public String getChunkTo() {
        return this.arrayToString(this.chunkTo.get());
    }

    @Override
    public String getTableFrom() {
        return this.arrayToString(this.tableFrom.get());
    }

    @Override
    public String getTableTo() {
        return this.arrayToString(this.tableTo.get());
    }

    private String arrayToString(Object[] array) {
        return array == null ? null : Arrays.toString(array);
    }

    public void reset() {
        this.snapshotRunning.set(false);
        this.snapshotCompleted.set(false);
        this.snapshotAborted.set(false);
        this.startTime.set(0L);
        this.stopTime.set(0L);
        this.rowsScanned.clear();
        this.remainingTables.clear();
        this.capturedTables.clear();
        this.chunkId.set(null);
        this.chunkFrom.set(null);
        this.chunkTo.set(null);
        this.tableFrom.set(null);
        this.tableTo.set(null);
    }
}

