/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.pipeline;

import shaded.adbmysql.io.debezium.data.Envelope;
import shaded.adbmysql.io.debezium.pipeline.spi.ChangeRecordEmitter;
import shaded.adbmysql.io.debezium.pipeline.spi.OffsetContext;
import shaded.adbmysql.io.debezium.pipeline.spi.Partition;
import shaded.adbmysql.io.debezium.schema.DataCollectionSchema;
import shaded.adbmysql.io.debezium.util.Clock;

public abstract class AbstractChangeRecordEmitter<P extends Partition, T extends DataCollectionSchema>
implements ChangeRecordEmitter<P> {
    private final P partition;
    private final OffsetContext offsetContext;
    private final Clock clock;

    public AbstractChangeRecordEmitter(P partition, OffsetContext offsetContext, Clock clock) {
        this.partition = partition;
        this.offsetContext = offsetContext;
        this.clock = clock;
    }

    @Override
    public void emitChangeRecords(DataCollectionSchema schema, ChangeRecordEmitter.Receiver<P> receiver) throws InterruptedException {
        Envelope.Operation operation = this.getOperation();
        switch (operation) {
            case CREATE: {
                this.emitCreateRecord(receiver, schema);
                break;
            }
            case READ: {
                this.emitReadRecord(receiver, schema);
                break;
            }
            case UPDATE: {
                this.emitUpdateRecord(receiver, schema);
                break;
            }
            case DELETE: {
                this.emitDeleteRecord(receiver, schema);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation: " + (Object)((Object)operation));
            }
        }
    }

    @Override
    public P getPartition() {
        return this.partition;
    }

    @Override
    public OffsetContext getOffset() {
        return this.offsetContext;
    }

    public Clock getClock() {
        return this.clock;
    }

    protected abstract void emitReadRecord(ChangeRecordEmitter.Receiver<P> var1, T var2) throws InterruptedException;

    protected abstract void emitCreateRecord(ChangeRecordEmitter.Receiver<P> var1, T var2) throws InterruptedException;

    protected abstract void emitUpdateRecord(ChangeRecordEmitter.Receiver<P> var1, T var2) throws InterruptedException;

    protected abstract void emitDeleteRecord(ChangeRecordEmitter.Receiver<P> var1, T var2) throws InterruptedException;
}

