/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.heartbeat;

import shaded.adbmysql.io.debezium.config.CommonConnectorConfig;
import shaded.adbmysql.io.debezium.heartbeat.DatabaseHeartbeatImpl;
import shaded.adbmysql.io.debezium.heartbeat.Heartbeat;
import shaded.adbmysql.io.debezium.heartbeat.HeartbeatConnectionProvider;
import shaded.adbmysql.io.debezium.heartbeat.HeartbeatErrorHandler;
import shaded.adbmysql.io.debezium.heartbeat.HeartbeatImpl;
import shaded.adbmysql.io.debezium.relational.RelationalDatabaseConnectorConfig;
import shaded.adbmysql.io.debezium.schema.DataCollectionId;
import shaded.adbmysql.io.debezium.schema.TopicSelector;
import shaded.adbmysql.io.debezium.util.SchemaNameAdjuster;
import shaded.adbmysql.io.debezium.util.Strings;

public class HeartbeatFactory<T extends DataCollectionId> {
    private final CommonConnectorConfig connectorConfig;
    private final TopicSelector<T> topicSelector;
    private final SchemaNameAdjuster schemaNameAdjuster;
    private final HeartbeatConnectionProvider connectionProvider;
    private final HeartbeatErrorHandler errorHandler;

    public HeartbeatFactory(CommonConnectorConfig connectorConfig, TopicSelector<T> topicSelector, SchemaNameAdjuster schemaNameAdjuster) {
        this(connectorConfig, topicSelector, schemaNameAdjuster, null, null);
    }

    public HeartbeatFactory(CommonConnectorConfig connectorConfig, TopicSelector<T> topicSelector, SchemaNameAdjuster schemaNameAdjuster, HeartbeatConnectionProvider connectionProvider, HeartbeatErrorHandler errorHandler) {
        this.connectorConfig = connectorConfig;
        this.topicSelector = topicSelector;
        this.schemaNameAdjuster = schemaNameAdjuster;
        this.connectionProvider = connectionProvider;
        this.errorHandler = errorHandler;
    }

    public Heartbeat createHeartbeat() {
        RelationalDatabaseConnectorConfig relConfig;
        if (this.connectorConfig.getHeartbeatInterval().isZero()) {
            return Heartbeat.DEFAULT_NOOP_HEARTBEAT;
        }
        if (this.connectorConfig instanceof RelationalDatabaseConnectorConfig && !Strings.isNullOrBlank((relConfig = (RelationalDatabaseConnectorConfig)this.connectorConfig).getHeartbeatActionQuery())) {
            return new DatabaseHeartbeatImpl(this.connectorConfig.getHeartbeatInterval(), this.topicSelector.getHeartbeatTopic(), this.connectorConfig.getLogicalName(), this.connectionProvider.get(), relConfig.getHeartbeatActionQuery(), this.errorHandler, this.schemaNameAdjuster);
        }
        return new HeartbeatImpl(this.connectorConfig.getHeartbeatInterval(), this.topicSelector.getHeartbeatTopic(), this.connectorConfig.getLogicalName(), this.schemaNameAdjuster);
    }
}

