/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.document;

import java.util.Optional;
import java.util.function.Consumer;
import shaded.adbmysql.io.debezium.annotation.Immutable;
import shaded.adbmysql.io.debezium.document.Paths;

@Immutable
public interface Path
extends Iterable<String> {
    public static Path root() {
        return Paths.RootPath.INSTANCE;
    }

    public static Optional<Path> optionalRoot() {
        return Paths.RootPath.OPTIONAL_OF_ROOT;
    }

    public static Path parse(String path) {
        return Paths.parse(path, true);
    }

    public static Path parse(String path, boolean resolveJsonPointerEscapes) {
        return Paths.parse(path, resolveJsonPointerEscapes);
    }

    default public boolean isRoot() {
        return this.size() == 0;
    }

    default public boolean isSingle() {
        return this.size() == 1;
    }

    default public boolean isMultiple() {
        return this.size() > 1;
    }

    public int size();

    public Optional<Path> parent();

    public Optional<String> lastSegment();

    public Path subpath(int var1);

    public String segment(int var1);

    default public Path append(String relPath) {
        return this.append(Path.parse(relPath));
    }

    public Path append(Path var1);

    public String toRelativePath();

    default public void fromRoot(Consumer<Path> consumer) {
        Path path = Path.root();
        for (String segment : this) {
            path = path.append(segment);
            consumer.accept(path);
        }
    }

    public static interface Segments {
        public static boolean isAfterLastIndex(String segment) {
            return "-".equals(segment);
        }

        public static boolean isArrayIndex(String segment) {
            return Segments.isAfterLastIndex(segment) || Segments.asInteger(segment).isPresent();
        }

        public static boolean isFieldName(String segment) {
            return !Segments.isArrayIndex(segment);
        }

        public static Optional<Integer> asInteger(String segment) {
            try {
                return Optional.of(Integer.valueOf(segment));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }

        public static Optional<Integer> asInteger(Optional<String> segment) {
            return segment.isPresent() ? Segments.asInteger(segment.get()) : Optional.empty();
        }
    }
}

