/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.document;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import shaded.adbmysql.io.debezium.annotation.ThreadSafe;
import shaded.adbmysql.io.debezium.document.Document;
import shaded.adbmysql.io.debezium.document.JacksonWriter;

@ThreadSafe
public interface DocumentWriter {
    public static DocumentWriter defaultWriter() {
        return JacksonWriter.INSTANCE;
    }

    public static DocumentWriter prettyWriter() {
        return JacksonWriter.PRETTY_WRITER;
    }

    default public byte[] writeAsBytes(Document document) {
        byte[] byArray;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.write(document, stream);
            byArray = stream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new byte[0];
            }
        }
        stream.close();
        return byArray;
    }

    public void write(Document var1, OutputStream var2) throws IOException;

    public void write(Document var1, Writer var2) throws IOException;

    public String write(Document var1) throws IOException;
}

