/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.document;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import shaded.adbmysql.io.debezium.annotation.ThreadSafe;
import shaded.adbmysql.io.debezium.document.Document;
import shaded.adbmysql.io.debezium.document.JacksonReader;

@ThreadSafe
public interface DocumentReader {
    public static DocumentReader defaultReader() {
        return JacksonReader.DEFAULT_INSTANCE;
    }

    public static DocumentReader floatNumbersAsTextReader() {
        return JacksonReader.FLOAT_NUMBERS_AS_TEXT_INSTANCE;
    }

    public Document read(InputStream var1) throws IOException;

    public Document read(Reader var1) throws IOException;

    public Document read(String var1) throws IOException;

    default public Document read(URL jsonUrl) throws IOException {
        return this.read(jsonUrl.openStream());
    }

    default public Document read(File jsonFile) throws IOException {
        return this.read(new BufferedInputStream(new FileInputStream(jsonFile)));
    }

    default public Document read(byte[] rawBytes) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(rawBytes);){
            Document document = DocumentReader.defaultReader().read(stream);
            return document;
        }
    }
}

