/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.document;

import java.util.Objects;
import shaded.adbmysql.io.debezium.annotation.Immutable;
import shaded.adbmysql.io.debezium.document.Document;
import shaded.adbmysql.io.debezium.document.Value;
import shaded.adbmysql.io.debezium.util.Strings;

@Immutable
final class BasicField
implements Document.Field,
Comparable<Document.Field> {
    private final CharSequence name;
    private final Value value;

    BasicField(CharSequence name, Value value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public CharSequence getName() {
        return this.name;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Document.Field) {
            Document.Field that = (Document.Field)obj;
            return this.getName().equals(that.getName()) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    public int compareTo(Document.Field that) {
        if (this == that) {
            return 0;
        }
        int diff = Strings.compareTo(this.getName(), that.getName());
        if (diff != 0) {
            return diff;
        }
        return Value.compareTo(this.getValue(), that.getValue());
    }
}

