/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.document;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import shaded.adbmysql.io.debezium.annotation.ThreadSafe;
import shaded.adbmysql.io.debezium.document.Array;
import shaded.adbmysql.io.debezium.document.JacksonReader;

@ThreadSafe
public interface ArrayReader {
    public static ArrayReader defaultReader() {
        return JacksonReader.DEFAULT_INSTANCE;
    }

    public Array readArray(InputStream var1) throws IOException;

    public Array readArray(Reader var1) throws IOException;

    public Array readArray(String var1) throws IOException;

    default public Array readArray(URL jsonUrl) throws IOException {
        return this.readArray(jsonUrl.openStream());
    }

    default public Array readArray(File jsonFile) throws IOException {
        return this.readArray(new BufferedInputStream(new FileInputStream(jsonFile)));
    }

    default public Array readArray(byte[] rawBytes) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(rawBytes);){
            Array array = ArrayReader.defaultReader().readArray(stream);
            return array;
        }
    }
}

