/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.crdt;

import shaded.adbmysql.io.debezium.annotation.NotThreadSafe;
import shaded.adbmysql.io.debezium.crdt.Count;
import shaded.adbmysql.io.debezium.crdt.DeltaCount;
import shaded.adbmysql.io.debezium.crdt.DeltaCounter;
import shaded.adbmysql.io.debezium.crdt.PNCount;
import shaded.adbmysql.io.debezium.crdt.PNCounter;
import shaded.adbmysql.io.debezium.crdt.StateBasedPNCounter;

@NotThreadSafe
class StateBasedPNDeltaCounter
extends StateBasedPNCounter
implements DeltaCounter {
    private PNCounter delta;

    protected StateBasedPNDeltaCounter() {
        this(0L, 0L, 0L, 0L);
    }

    protected StateBasedPNDeltaCounter(long totalAdds, long totalRemoves, long recentAdds, long recentRemoves) {
        super(totalAdds, totalRemoves);
        this.delta = new StateBasedPNCounter(recentAdds, recentRemoves);
    }

    @Override
    public DeltaCounter increment() {
        super.increment();
        this.delta.increment();
        return this;
    }

    @Override
    public DeltaCounter decrement() {
        super.decrement();
        this.delta.decrement();
        return this;
    }

    @Override
    public long incrementAndGet() {
        this.delta.incrementAndGet();
        return super.incrementAndGet();
    }

    @Override
    public long decrementAndGet() {
        this.delta.decrementAndGet();
        return super.decrementAndGet();
    }

    @Override
    public long getAndIncrement() {
        this.delta.getAndIncrement();
        return super.getAndIncrement();
    }

    @Override
    public long getAndDecrement() {
        this.delta.getAndDecrement();
        return super.getAndDecrement();
    }

    @Override
    public PNCount getChanges() {
        return this.delta;
    }

    @Override
    public boolean hasChanges() {
        return this.delta.getIncrement() != 0L || this.delta.getDecrement() != 0L;
    }

    @Override
    public Count getPriorCount() {
        final long value = super.get() - this.delta.get();
        return new Count(){

            @Override
            public long get() {
                return value;
            }
        };
    }

    @Override
    public void reset() {
        this.delta = new StateBasedPNCounter();
    }

    @Override
    public DeltaCounter merge(Count other) {
        if (other instanceof DeltaCount) {
            DeltaCount that = (DeltaCount)other;
            this.delta.merge(that.getChanges());
            super.merge(that.getChanges());
        } else {
            super.merge(other);
        }
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + " (changes " + this.delta + ")";
    }
}

