/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql.util;

import java.util.regex.Pattern;

public class ADBMySqlErrorMessageUtils {
    private static final Pattern SERVER_ID_CONFLICT = Pattern.compile(".*A slave with the same server_uuid/server_id as this slave has connected to the master.*");
    private static final Pattern MISSING_BINLOG_POSITION_WHEN_BINLOG_EXPIRE = Pattern.compile(".*The connector is trying to read binlog.*but this is no longer available on the server.*");
    private static final Pattern MISSING_TRANSACTION_WHEN_BINLOG_EXPIRE = Pattern.compile(".*Cannot replicate because the (master|source) purged required binary logs.*");

    public static String optimizeErrorMessage(String msg) {
        if (msg == null) {
            return null;
        }
        if (SERVER_ID_CONFLICT.matcher(msg).matches()) {
            msg = msg + "\nThe 'server-id' in the adb mysql cdc connector should be globally unique, but conflicts happen now.\nThe server id conflict may happen in the following situations: \n1. The server id has been used by other adb mysql cdc table in the current job.\n2. The server id has been used by the adb mysql cdc table in other jobs.\n3. The server id has been used by other sync tools like canal, debezium and so on.\n";
        } else if (MISSING_BINLOG_POSITION_WHEN_BINLOG_EXPIRE.matcher(msg).matches() || MISSING_TRANSACTION_WHEN_BINLOG_EXPIRE.matcher(msg).matches()) {
            msg = msg + "\nThe required binary logs are no longer available on the server. This may happen in following situations:\n1. The speed of CDC source reading is too slow to exceed the binlog expired period. You can consider increasing the binary log expiration period, you can also to check whether there is back pressure in the job and optimize your job.\n2. The job runs normally, but something happens in the database and lead to the binlog cleanup. You can try to check why this cleanup happens from ADBMySQL side.";
        }
        return msg;
    }
}

