/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql.legacy;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.adbmysql.io.debezium.DebeziumException;
import shaded.adbmysql.io.debezium.annotation.NotThreadSafe;
import shaded.adbmysql.io.debezium.config.CommonConnectorConfig;
import shaded.adbmysql.io.debezium.config.Configuration;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnector;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnectorConfig;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlDefaultValueConverter;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlSystemVariables;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlValueConverters;
import shaded.adbmysql.io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import shaded.adbmysql.io.debezium.connector.mysql.legacy.Filters;
import shaded.adbmysql.io.debezium.connector.mysql.legacy.SourceInfo;
import shaded.adbmysql.io.debezium.document.Document;
import shaded.adbmysql.io.debezium.jdbc.JdbcValueConverters;
import shaded.adbmysql.io.debezium.jdbc.TemporalPrecisionMode;
import shaded.adbmysql.io.debezium.relational.RelationalDatabaseSchema;
import shaded.adbmysql.io.debezium.relational.SystemVariables;
import shaded.adbmysql.io.debezium.relational.Table;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.relational.TableSchemaBuilder;
import shaded.adbmysql.io.debezium.relational.Tables;
import shaded.adbmysql.io.debezium.relational.ddl.DdlChanges;
import shaded.adbmysql.io.debezium.relational.ddl.DdlParser;
import shaded.adbmysql.io.debezium.relational.history.DatabaseHistory;
import shaded.adbmysql.io.debezium.relational.history.DatabaseHistoryMetrics;
import shaded.adbmysql.io.debezium.relational.history.HistoryRecordComparator;
import shaded.adbmysql.io.debezium.relational.history.KafkaDatabaseHistory;
import shaded.adbmysql.io.debezium.schema.TopicSelector;
import shaded.adbmysql.io.debezium.text.MultipleParsingExceptions;
import shaded.adbmysql.io.debezium.text.ParsingException;
import shaded.adbmysql.io.debezium.util.Collect;
import shaded.adbmysql.io.debezium.util.SchemaNameAdjuster;

@NotThreadSafe
public class MySqlSchema
extends RelationalDatabaseSchema {
    private static final Logger logger = LoggerFactory.getLogger(MySqlSchema.class);
    private final Set<String> ignoredQueryStatements = Collect.unmodifiableSet("BEGIN", "END", "FLUSH PRIVILEGES");
    private final DdlParser ddlParser;
    private final Filters filters;
    private final DatabaseHistory dbHistory;
    private final DdlChanges ddlChanges;
    private final HistoryRecordComparator historyComparator;
    private final boolean skipUnparseableDDL;
    private final boolean storeOnlyCapturedTablesDdl;
    private boolean recoveredTables;

    public MySqlSchema(MySqlConnectorConfig configuration, final Predicate<String> gtidFilter, boolean tableIdCaseInsensitive, TopicSelector<TableId> topicSelector, Filters tableFilters) {
        super(configuration, topicSelector, Tables.TableFilter.fromPredicate(tableFilters.tableFilter()), tableFilters.columnFilter(), new TableSchemaBuilder(MySqlSchema.getValueConverters(configuration), new MySqlDefaultValueConverter(MySqlSchema.getValueConverters(configuration)), SchemaNameAdjuster.create(), configuration.customConverterRegistry(), configuration.getSourceInfoStructMaker().schema(), configuration.getSanitizeFieldNames(), false), tableIdCaseInsensitive, configuration.getKeyMapper());
        Configuration config = configuration.getConfig();
        this.filters = tableFilters;
        String connectorName = config.getString("name", configuration.getLogicalName());
        Configuration dbHistoryConfig = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)config.subset("database.history.", false).edit().withDefault(DatabaseHistory.NAME, connectorName + "-dbhistory")).with(KafkaDatabaseHistory.INTERNAL_CONNECTOR_CLASS, MySqlConnector.class.getName())).with(KafkaDatabaseHistory.INTERNAL_CONNECTOR_ID, configuration.getLogicalName())).build();
        this.skipUnparseableDDL = dbHistoryConfig.getBoolean(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS);
        this.storeOnlyCapturedTablesDdl = Boolean.valueOf(dbHistoryConfig.getFallbackStringPropertyWithWarning(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL));
        this.ddlParser = new MySqlAntlrDdlParser(true, false, configuration.isSchemaCommentsHistoryEnabled(), MySqlSchema.getValueConverters(configuration), this.getTableFilter());
        this.ddlChanges = this.ddlParser.getDdlChanges();
        this.dbHistory = config.getInstance(MySqlConnectorConfig.DATABASE_HISTORY, DatabaseHistory.class);
        if (this.dbHistory == null) {
            throw new ConnectException("Unable to instantiate the database history class " + config.getString(MySqlConnectorConfig.DATABASE_HISTORY));
        }
        this.historyComparator = new HistoryRecordComparator(){

            @Override
            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return SourceInfo.isPositionAtOrBefore(recorded, desired, gtidFilter);
            }
        };
        this.dbHistory.configure(dbHistoryConfig, this.historyComparator, new DatabaseHistoryMetrics(configuration, false), true);
    }

    private static MySqlValueConverters getValueConverters(MySqlConnectorConfig configuration) {
        TemporalPrecisionMode timePrecisionMode = configuration.getTemporalPrecisionMode();
        JdbcValueConverters.DecimalMode decimalMode = configuration.getDecimalMode();
        String bigIntUnsignedHandlingModeStr = configuration.getConfig().getString(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE);
        MySqlConnectorConfig.BigIntUnsignedHandlingMode bigIntUnsignedHandlingMode = MySqlConnectorConfig.BigIntUnsignedHandlingMode.parse(bigIntUnsignedHandlingModeStr);
        JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode = bigIntUnsignedHandlingMode.asBigIntUnsignedMode();
        boolean timeAdjusterEnabled = configuration.getConfig().getBoolean(MySqlConnectorConfig.ENABLE_TIME_ADJUSTER);
        return new MySqlValueConverters(decimalMode, timePrecisionMode, bigIntUnsignedMode, configuration.binaryHandlingMode(), timeAdjusterEnabled ? MySqlValueConverters::adjustTemporal : x -> x, (message, exception) -> {
            if (configuration.getEventProcessingFailureHandlingMode() == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
                throw new DebeziumException(message, exception);
            }
            if (configuration.getEventProcessingFailureHandlingMode() == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
                logger.warn(message, (Throwable)exception);
            }
        });
    }

    public HistoryRecordComparator historyComparator() {
        return this.historyComparator;
    }

    public synchronized void start() {
        this.dbHistory.start();
    }

    public synchronized void shutdown() {
        this.dbHistory.stop();
    }

    public Filters filters() {
        return this.filters;
    }

    public String[] capturedTablesAsStringArray() {
        Set<TableId> tables = this.tableIds();
        String[] ret = new String[tables.size()];
        int i = 0;
        for (TableId table : tables) {
            ret[i++] = table.toString();
        }
        return ret;
    }

    public boolean isTableCaptured(TableId id) {
        return this.filters.tableFilter().test(id);
    }

    public String historyLocation() {
        return this.dbHistory.toString();
    }

    public void setSystemVariables(Map<String, String> variables) {
        variables.forEach((varName, value) -> this.ddlParser.systemVariables().setVariable(MySqlSystemVariables.MySqlScope.SESSION, (String)varName, (String)value));
    }

    public SystemVariables systemVariables() {
        return this.ddlParser.systemVariables();
    }

    protected void appendDropTableStatement(StringBuilder sb, TableId tableId) {
        sb.append("DROP TABLE ").append(tableId).append(" IF EXISTS;").append(System.lineSeparator());
    }

    protected void appendCreateTableStatement(StringBuilder sb, Table table) {
        sb.append("CREATE TABLE ").append(table.id()).append(';').append(System.lineSeparator());
    }

    public void loadHistory(SourceInfo startingPoint) {
        this.tables().clear();
        this.dbHistory.recover(startingPoint.partition(), startingPoint.offset(), this.tables(), this.ddlParser);
        this.recoveredTables = !this.tableIds().isEmpty();
        this.refreshSchemas();
    }

    public boolean historyExists() {
        return this.dbHistory.exists();
    }

    public void intializeHistoryStorage() {
        if (!this.dbHistory.storageExists()) {
            this.dbHistory.initializeStorage();
        }
    }

    public void refreshSchemas() {
        this.clearSchemas();
        this.tableIds().forEach(id -> {
            Table table = this.tableFor((TableId)id);
            this.buildAndRegisterSchema(table);
        });
    }

    public boolean applyDdl(SourceInfo source, String databaseName, String ddlStatements, DdlChanges.DatabaseStatementStringConsumer statementConsumer) {
        Set<TableId> changes;
        block13: {
            block11: {
                block12: {
                    if (this.ignoredQueryStatements.contains(ddlStatements)) {
                        return false;
                    }
                    try {
                        this.ddlChanges.reset();
                        this.ddlParser.setCurrentSchema(databaseName);
                        this.ddlParser.parse(ddlStatements, this.tables());
                    }
                    catch (MultipleParsingExceptions | ParsingException e) {
                        if (this.skipUnparseableDDL) {
                            logger.warn("Ignoring unparseable DDL statement '{}': {}", (Object)ddlStatements, (Object)e);
                        }
                        throw e;
                    }
                    changes = this.tables().drainChanges();
                    if (this.storeOnlyCapturedTablesDdl && !this.ddlChanges.anyMatch(this.filters.databaseFilter(), this.filters.tableFilter())) break block11;
                    if (statementConsumer != null) {
                        if (!this.ddlChanges.isEmpty() && this.ddlChanges.applyToMoreDatabasesThan(databaseName)) {
                            this.ddlChanges.groupStatementStringsByDatabase((dbName, tables, ddl) -> {
                                if (this.filters.databaseFilter().test(dbName) || dbName == null || "".equals(dbName)) {
                                    if (dbName == null) {
                                        dbName = "";
                                    }
                                    statementConsumer.consume(dbName, tables, ddl);
                                }
                            });
                        } else if (this.filters.databaseFilter().test(databaseName) || databaseName == null || "".equals(databaseName)) {
                            if (databaseName == null) {
                                databaseName = "";
                            }
                            statementConsumer.consume(databaseName, changes, ddlStatements);
                        }
                    }
                    if (!this.storeOnlyCapturedTablesDdl || this.isGlobalSetVariableStatement(ddlStatements, databaseName)) break block12;
                    if (!changes.stream().anyMatch(this.filters().tableFilter()::test)) break block13;
                }
                this.dbHistory.record(source.partition(), source.offset(), databaseName, ddlStatements);
                break block13;
            }
            logger.debug("Changes for DDL '{}' were filtered and not recorded in database history", (Object)ddlStatements);
        }
        changes.forEach(tableId -> {
            Table table = this.tableFor((TableId)tableId);
            if (table == null) {
                this.removeSchema((TableId)tableId);
            } else {
                this.buildAndRegisterSchema(table);
            }
        });
        return true;
    }

    public boolean isGlobalSetVariableStatement(String ddl, String databaseName) {
        return databaseName == null && ddl != null && ddl.toUpperCase().startsWith("SET ");
    }

    public boolean isStoreOnlyCapturedTablesDdl() {
        return this.storeOnlyCapturedTablesDdl;
    }

    @Override
    public boolean tableInformationComplete() {
        return this.recoveredTables;
    }
}

