/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql.antlr.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.adbmysql.io.debezium.antlr.AntlrDdlParser;
import shaded.adbmysql.io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import shaded.adbmysql.io.debezium.connector.mysql.antlr.listener.AlterTableParserListener;
import shaded.adbmysql.io.debezium.ddl.parser.mysql.generated.MySqlParser;
import shaded.adbmysql.io.debezium.ddl.parser.mysql.generated.MySqlParserBaseListener;
import shaded.adbmysql.io.debezium.relational.TableEditor;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.text.ParsingException;

public class CreateUniqueIndexParserListener
extends MySqlParserBaseListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlterTableParserListener.class);
    private final MySqlAntlrDdlParser parser;

    public CreateUniqueIndexParserListener(MySqlAntlrDdlParser parser) {
        this.parser = parser;
    }

    @Override
    public void enterCreateIndex(MySqlParser.CreateIndexContext ctx) {
        if (ctx.UNIQUE() != null) {
            TableId tableId = this.parser.parseQualifiedTableId(ctx.tableName().fullId());
            if (!this.parser.getTableFilter().isIncluded(tableId)) {
                LOG.debug("{} is not monitored, no need to process unique index", (Object)tableId);
                return;
            }
            TableEditor tableEditor = this.parser.databaseTables().editTable(tableId);
            if (tableEditor != null) {
                if (!tableEditor.hasPrimaryKey()) {
                    this.parser.parsePrimaryIndexColumnNames(ctx.indexColumnNames(), tableEditor);
                    this.parser.signalCreateIndex(this.parser.parseName(ctx.uid()), tableId, ctx);
                    this.parser.databaseTables().overwriteTable(tableEditor.create());
                }
            } else {
                throw new ParsingException(null, "Trying to create index on non existing table " + tableId.toString() + ".Query: " + AntlrDdlParser.getText(ctx));
            }
        }
        super.enterCreateIndex(ctx);
    }
}

